#include "fitstoiwtr.h"
#include "toimanager.h"



extern void fits_lock();
extern void fits_unlock();

FITSTOIWriter::FITSTOIWriter(string fn) {
  fname = fn;
  fstatus = 0;
  outFlags = false;

  // Open file
  remove(fname.c_str()); 
  fits_lock();
  fits_create_file(&fptr,fname.c_str(),&fstatus);
  fits_unlock();
  name = "wtr";
}

FITSTOIWriter::~FITSTOIWriter() {
}

void FITSTOIWriter::setOutFlags(bool yn) {
  outFlags = yn;
}

void FITSTOIWriter::addInput(string name, TOI* toi) {
  declareInput(name);
  fwinputs.push_back(toi);
}


void FITSTOIWriter::run() {
  cout << "fitstoiwriter running" << endl;
  // init done here
  delete[] inTOIs;
  inTOIs = new (TOI*[fwinputs.size()]);

  for (int i=0; i<fwinputs.size(); i++) {
    inTOIs[i] = fwinputs[i];
  }

  int ndata = inIx.size();
  int ncols = inIx.size() * (outFlags ? 2 : 1) + 1;

  char** colnames = new (char*[ncols]);
  char** coltypes = new (char*[ncols]);
  char** colunits = new (char*[ncols]);

  colnames[0] = "samplenum";
  coltypes[0] = "1D";
  colunits[0] = "integer";

  for (map<string, int>::iterator ii = inIx.begin(); ii != inIx.end(); ii++) {
    int j = (*ii).second;
    string n = (*ii).first;
    if (outFlags) j += j;
    colnames[j+1] = const_cast<char*>(n.c_str());
    coltypes[j+1] = "1D";
    colunits[j+1] = "?";
    if (outFlags) {
      colnames[j+2] = const_cast<char*>((n+"_flg").c_str());
      coltypes[j+2] = "1D";
      colunits[j+2] = "?";
    }
  }

  fits_lock();
  fits_create_tbl(fptr, BINARY_TBL, 0, ncols, colnames, coltypes, colunits, NULL, &fstatus);
  fits_write_date(fptr, &fstatus);
  fits_unlock();

  delete[] colunits;
  delete[] coltypes;
  delete[] colnames;

  // Add headers ?

  // loop

  int fitsLine = 1;
  int snb = getMinIn();
  int sne = getMaxIn();

  for (int sn = snb; sn <= sne; sn++) {
    try {
      fits_lock();
      double xx = sn;
      fits_write_col_dbl(fptr, 1, fitsLine, 1, 1, &xx, &fstatus);
      fits_unlock();
      for (int i=0; i<ndata; i++) {
	double x = -9.e19;  // $CHECK$ - Reza valeur par defaut !
	if (checkInputTOIIndex(i)) x = getData(i, sn);
	fits_lock();
	if (outFlags) {
	  fits_write_col_dbl(fptr, 2*i+2, fitsLine, 1, 1, &x, &fstatus);
	  if (checkInputTOIIndex(i))   x = getFlag(i, sn);
	  else x = -9.e19;  // $CHECK$ - Reza valeur par defaut !
	  fits_write_col_dbl(fptr, 2*i+3, fitsLine, 1, 1, &x, &fstatus);
	} else {
	  fits_write_col_dbl(fptr, i+2, fitsLine, 1, 1, &x, &fstatus);
	}
	if (fstatus != 0) {
	  cerr << "fitstoiwtr error sn = " << sn << " i = "<< i << endl;
	  fits_report_error(stderr, fstatus);
	  abort();
	}
	fits_unlock();
      }
    } catch (PException e) {
      cout << "fitstoiwtr exception " << e.Msg() << endl;
      continue;
    }
    fitsLine++;
  }

  fits_lock();
  fits_close_file(fptr, &fstatus);
  fits_report_error(stderr, fstatus);
  fits_unlock();
  cout << "fitstoiwriter done" << endl;
}








