// This may look like C code, but it is really -*- C++ -*-
#ifndef TOI_H
#define TOI_H

#include "config.h"

#include <pthread.h>
#include <vector>
using namespace std;

#ifdef WITH_SOPHYA
#include "array.h"
#include "pexceptions.h"
using namespace SOPHYA;
#else
#include "apexceptions.h"
#endif



class TOIProcessor;

class TOI {
public:
  TOI();
  TOI(string name);
  virtual ~TOI();

  //   ----- Rajouts Reza 12/3/2001
  virtual void PrintStatus(ostream & os) const;
  //  Fin rajouts Reza 12/3/2001 ------

#ifdef WITH_SOPHYA
  virtual Array         getData(int iStart, int iEnd);
  virtual Array         getError(int iStart, int iEnd);
  virtual TArray<int_4> getFlag(int iStart, int iEnd);
#endif
    
  virtual double        getData(int i);
  virtual double        getError(int i);
  virtual int_4         getFlag(int i);

  enum DataStatus       {DATA_OK=0, DATA_DELETED, DATA_NOT_YET};
  virtual DataStatus    isDataAvail(int iStart, int iEnd);
  virtual DataStatus    isDataAvail(int i);
  virtual void          waitForData(int iStart, int iEnd);
  virtual void          waitForData(int i);
  virtual void          waitForAnyData();
  virtual int           nextDataAvail(int iAfter)=0;
  virtual bool          hasSomeData()=0;
  
  virtual void          putData(int i, double value, int_4 flag=0);
  virtual void          putDataError(int i, double value, 
		                     double error, int_4 flag=0);

  virtual void          wontNeedBefore(int i);
  
  bool  dbg;

  void setName(string n) {name =n;}
  string getName() const {return name;}

protected:
  TOI*                  errorTOI;
  pthread_mutex_t       mutex;
  //   ----- Rajouts Reza 12/3/2001
  pthread_cond_t        condv;
  bool                  fgwaitput;
  bool                  fgwaitget;
  bool                  fgsigput;
  bool                  fgsigget;
  int                   countwaitput;
  int                   countwaitget;
  //  Fin rajouts Reza 12/3/2001 ------

  TOIProcessor*         producer;
  vector<TOIProcessor*> consumers;
  double                defaultValue;
  
#ifdef WITH_SOPHYA
  virtual Array         doGetData(int iStart, int iEnd)=0;
  virtual TArray<int_4> doGetFlag(int iStart, int iEnd)=0;
#endif
  virtual double        doGetData(int i)=0;
  virtual int_4         doGetFlag(int i)=0;
  virtual void          doPutData(int i, double value, int_4 flag=0)=0;
  virtual void          doWontNeedBefore(int i);

  virtual DataStatus    isDataAvailNL(int iStart, int iEnd)=0;
  virtual DataStatus    isDataAvailNL(int i);

  virtual void          setProducer(TOIProcessor* prod);
  virtual void          addConsumer(TOIProcessor* prod);
  friend class          TOIProcessor;
      
  string name;

  virtual int           getMinSn();
  virtual int           getMaxSn();
  void  TOIInit();

  // Il faut faire attention avec mutex et condv, si TOI cree sur le stack !
  // Il faut donc faire new TOI  -    Reza 11/3/2001
  void lock() {pthread_mutex_lock(&mutex);}
  void unlock() {pthread_mutex_unlock(&mutex);}

  //   ----- Rajouts Reza 12/3/2001
  void wait() {pthread_cond_wait(&condv, &mutex);}
  void signal() {pthread_cond_signal(&condv);}
  void broadcast() {pthread_cond_broadcast(&condv);}
  inline void waitPut() 
    {fgwaitput=true; countwaitput++; pthread_cond_wait(&condv, &mutex);}
  inline void waitGet() 
    {fgwaitget=true; countwaitget++; pthread_cond_wait(&condv, &mutex);}
  inline bool isPutWaiting() const { return fgwaitput; }
  inline bool isGetWaiting() const { return fgwaitget; }
  inline void signalPut() {fgsigput=true;}
  inline void signalGet() {fgsigget=true;}
  inline void cleanWaitPut() { fgsigput = fgwaitput = false; }
  inline void cleanWaitGet() { fgsigget = fgwaitget = false; }

public:
  inline int  getCountWaitPut() const { return countwaitput; }
  inline int  getCountWaitGet() const { return countwaitget; }
  //  Fin rajouts Reza 12/3/2001 ------

};

inline ostream & operator << (ostream & os, TOI const & toi)
{ toi.PrintStatus(os); return os; }

class TOIRegular : public TOI {
};

// Classe de TOI avec une fenetre glissante, et echantillonnage regulier.
// Pour le moment au moins,
// il faut que les providers fassent arriver les donnees par samplenum croissant.
class TOIRegularWindow : public TOIRegular {
public:
  TOIRegularWindow();
  TOIRegularWindow(string nm);
  virtual ~TOIRegularWindow();

  virtual DataStatus isDataAvailNL(int iStart, int iEnd);
  virtual DataStatus isDataAvailNL(int i); // override required


//protected:
  vector<double> data;
  vector<int_4>  flags;
  long          i0;
  double defaultValue;
 
#ifdef WITH_SOPHYA
  virtual Array         doGetData(int iStart, int iEnd);
  virtual TArray<int_4> doGetFlag(int iStart, int iEnd);
#endif
  virtual double        doGetData(int i);
  virtual int_4         doGetFlag(int i);
   
  virtual void          doPutData(int i, double value, int_4 flag=0);
  virtual void          doWontNeedBefore(int i);

  virtual int           nextDataAvail(int iAfter);
  virtual bool          hasSomeData();
};

#endif
