// This may look like C code, but it is really -*- C++ -*-


#ifndef TOIPROCESSOR_H
#define TOIPROCESSOR_H

#include "config.h"

#include <pthread.h>

#include <string>
#include <map>
#include <iostream.h>

#ifndef NO_SOPHYA
#include "tarray.h"
using namespace SOPHYA;
#endif

#include "toi.h"


class TOIProcessor {
public:
  virtual void init();  
  // Les methodes qui suivent peuvent etre appelees par init
protected:
  int declareInput(string toi);
  int declareOutput(string toi);  
  
  // void declareMultInput(string toi);
  // Question : multiple output ? 

  void chkinit() {
   if (!inited) {init(); afterinit(); inited=true;}
  }
  bool inited;
  virtual void afterinit();

public:
  virtual void run();
  // Les methodes qui suivent peut etre appelees par run
protected:
#ifndef NO_SOPHYA
  Array         getData(int toiIndex, int iStart, int iEnd);
  Array         getError(int toiIndex, int iStart, int iEnd);
  TArray<int_4> getFlag(int toiIndex, int iStart, int iEnd);
#endif
  // si multiple input (indexed input), tableau 2D.

  // Les methodes qui suivent ne peuvent etre 
  // utilisees que sur des entrees simples
  double        getData(int toiIndex, int i);
  double        getError(int toiIndex, int i);
  int_4         getFlag(int toiIndex, int i);

  void          wontNeedBefore(int i);
  int           wontNeedValue;
  void          setNeededHistory(int nsamples); // -1 : disable

  void          putData(int toiIndex, int i, double value, int_4 flag=0);
  void          putDataError(int toiIndex, int i, double value, 
		             double error, int_4 flag=0);

  // Gestion des bornes pour les transformations de TOIs...
  virtual int   calcMinOut();
  virtual int   calcMaxOut();

  virtual int   getMinOut();
  virtual int   getMaxOut();
  int           minOut;
  int           maxOut;

  virtual int   getMinIn();
  virtual int   getMaxIn();
  // Implementation par defaut
  int           upExtra;
  int           lowExtra;

  int           neededHistory;

protected:
  int           getInputTOIIndex(string toi);
  int           getOutputTOIIndex(string toi);

  //  Methodes rajoutees par Reza 11/3/2001
  TOI*          getInputTOI(int toiIndex);
  TOI*          getOutputTOI(int toiIndex);
  bool          checkInputTOIIndex(int toiIndex);
  bool          checkOutputTOIIndex(int toiIndex);

  //  Fin rajout Reza 11/3/2001 

  void          autoWontNeed(int iCur);
  int           lastAWN;

public:
  // Appele par les assembleurs de pipeline
  virtual void  addInput(string name, TOI* toi);
  virtual void  addOutput(string name, TOI* toi);


  int getNIn()  {chkinit(); return inIx.size();}
  int getNOut() {chkinit(); return outIx.size();}
  string getOutName(int i);
  string getInName(int i);

  //  Methodes rajoutees par Reza 11/3/2001
  void          PrintStatus(ostream & os) ; // const plus tard
  //  Fin rajout Reza 11/3/2001 

  virtual void  start();
  
  TOIProcessor();
  virtual ~TOIProcessor();

protected:

  map<string, int> inIx;
  map<string, int> outIx;
  TOI**  inTOIs;
  TOI**  outTOIs;

  string name;
  // Thread handling
  pthread_t        thread;
  pthread_cond_t   dataReady;
  pthread_mutex_t  mutex;
  pthread_mutexattr_t mutattr;

  void lock() {
    pthread_mutex_lock(&mutex);
  }

  void unlock() {
    pthread_mutex_unlock(&mutex);
  }
  
  void wait()   {
    pthread_cond_wait(&dataReady, &mutex); 
  }

  void notify();
  

  friend class TOI;
  
  static void* ThreadStart(void *);
};

inline ostream & operator << (ostream & os, TOIProcessor /*const*/ & toip)
{ toip.PrintStatus(os); return os; }


#endif

