// This may look like C code, but it is really -*- C++ -*-

#ifndef RZTOIPROC_H
#define RZTOIPROC_H

#include "toiprocessor.h"

class RzTOIProc : public TOIProcessor {
public:
  RzTOIProc(int w1=4096, int w2=128, int nmax=20);
  inline void setOutPPF(string const & ppfname) 
              { outppf = ppfname; }
  virtual void init();  
  virtual void run();

protected:
  int _width1;
  int _width2;
  int _nmax;
  string outppf;
};

class RzSimpleTOIProc : public TOIProcessor {
public:
  RzSimpleTOIProc(double fact=1.0, int npr=1000);
  virtual void init();  
  virtual void run();

protected:
  double _fact;
  int _nprt;
};

#endif
