#include "rztoi.h"
#include "toimanager.h"
#include "pexceptions.h"
#include "fftpserver.h"
#include "timing.h"

RzTOIProc::RzTOIProc(int w1, int w2, int nmax)
{
  cout << "RzTOIProc::RzTOIProc() Width= " << w1 << "," << w2 << " NMax=" << nmax;
  _width1 = w1;
  _width2 = w2;
  _nmax = nmax;
}

void RzTOIProc::init() {
  cout << "RzTOIProc::init" << endl;
  declareInput("signal");
  declareOutput("sfout");
  name = "rzproc";
  upExtra = 1;
}

void RzTOIProc::run() {
  //  TOIManager* mgr = TOIManager::getManager();
  int snb = getMinIn();
  int sne = getMaxIn();

  int istart, iend;
  int ilast;
  ilast = istart = snb; 
  iend = sne;
  int ii, jj;

  try {

    FFTPackServer ffts;

    bool fgppf = false;
    int nkv = 0;
    //    int nkvmx = 8;
#define nkvmx 8 
    Vector vkin[nkvmx];
    Vector vkout[nkvmx];
    TVector< complex<r_8> > vkfft[nkvmx];
    if (outppf.length() > 0)    fgppf = true;
    
    Vector vin, vout;
    TVector< complex<r_8> > vfft;

    for (int k=0; k<_nmax; k++) {
      istart = snb + k*_width1;
      //      if (k>0)  istart -= _width2;
      iend = istart +_width1;
      cout << " RzTOIProc::run() - Processing bloc k= " << k 
	   << " istart= " << istart << " iend= " << iend << endl;
      if (iend > sne) {
	cout << " RzTOIProc::run() - iend > getMaxIn() -> break " << endl;
	break;
      }
      //      Vector vin = getData(0, istart, iend);
      vin.ReSize(_width1);
      jj = 0;
      for(ii=istart; ii<iend; ii++)  
	vin(jj++) = getData(0, ii);
      
      cout << " End of getData() for bloc " << k << endl;

      vout.ReSize(vin.Size());
      double vlast = 0.;
      for(int i=0; i<vout.Size()-_width2; i++) {
	vout(i) = vin(Range(i,-1,_width2)).Sum()/(r_8)_width2;
	putData(0, i+istart, vout(i));
	vlast = vout(i);
      }

      for(int i=vout.Size()-_width2; i<vout.Size(); i++) {
	vout(i) = vlast;
	putData(0, i+istart, vout(i));
      }

      cout << " End of putData() for bloc " << k << " Mean vout= " 
	   << vout.Sum()/vout.Size() << endl;

      vin -= vout;

      TVector< complex<r_8> > vfft;
      ffts.FFTForward(vin, vfft);
      ilast = iend;
      /*
      if (fgppf) {
	string nom;
	nom = "in" + (string)MuTyV(k);
	ppo->PutObject(vin, nom);
	nom = "out" + (string)MuTyV(k);
	ppo->PutObject(vout, nom);
	nom = "fft" + (string)MuTyV(k);
	ppo->PutObject(vfft, nom);
      }
      */
      if (fgppf && (nkv < nkvmx) ) {
	vkin[nkv] = vin;
	vkout[nkv] = vout;
	vkfft[nkv] = vfft;
	nkv++;
      }
      PrtTim("End of bloc");
    }

    if (fgppf) {
      cout << " Writing to Out PPF ... " << endl;
      POutPersist ppo(outppf);
      for(int kkk=0; kkk<nkv; kkk++) {
	string nom;
	nom = "in" + (string)MuTyV(kkk);
	ppo.PutObject(vkin[kkk], nom);
	nom = "out" + (string)MuTyV(kkk);
	ppo.PutObject(vkout[kkk], nom);
	nom = "fft" + (string)MuTyV(kkk);
	ppo.PutObject(vkfft[kkk], nom);
      }
    }

    cout << " Filling -9999 : putData(0, ii, -9999.) ii: "
	 << iend << " .. " << sne << endl;
    double xxx;
    for(ii=iend; ii<sne; ii++) {
      if ((ii-iend)%1000 == 0) 
	cout << " RzTOIProc::run() - Processing sample ii= " << ii
	     << endl;
      xxx=getData(0,ii);
      putData(0,ii,xxx-9999.);
    }

  }
  catch (PException & e) {
    cout << "RzTOIProc exception Msg= " << e.Msg() << endl;
  }
}



RzSimpleTOIProc::RzSimpleTOIProc(double fact, int npr)
{
  cout << "RzSimpleTOIProc::RzSimpleTOIProc() factor= " << fact 
       << " npr=" << npr << endl; 
  _fact = fact;
  _nprt = npr;
}

void RzSimpleTOIProc::init() {
  cout << "RzSimpleTOIProc::init" << endl;
  declareInput("signal");
  declareOutput("sfout");
  name = "rzsimpleproc";
  upExtra = 1;
}

void RzSimpleTOIProc::run() {
  //  TOIManager* mgr = TOIManager::getManager();
  int snb = getMinIn();
  int sne = getMaxIn();

  cout << " RzSimpleTOIProc::run(): snb=" << snb << " sne=" << sne << endl;

  double val;
  try {
    for (int k=snb; k<sne; k++) {
      if ((k-snb)%_nprt == 0) 
	cout << " RzSimpleTOIProc::run() - Processing sample k= " << k
	     << endl;

      val = getData(0, k);
      putData(0, k, val*_fact);
    }
  }
  catch (PException & e) {
    cout << "RzSimpleTOIProc exception Msg= " << e.Msg() << endl;
  }
}
