#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <iostream.h>

#include "histinit.h"
#include "dvlist.h"
#include "ntuple.h"
#include "xntuple.h"
#include "fitsxntuple.h"
#include "fitsntuple.h"

/*!
  \ingroup PrgUtil
  \file scanfits.cc
  \brief \b scanfits: Check and scan FITS files 

  Scan FITS files and prints information on each FITS bloc in file.
  Uses the FitsIOServer module. 

  \verbatim
  Usage: scanfits FITSFilename
  \endverbatim
 */

string FITSExtType2String(FitsFile::FitsExtensionType exttype)
{
  if (exttype == FitsFile::FitsExtensionType_IMAGE) return("IMAGE");
  else if (exttype == FitsFile::FitsExtensionType_ASCII_TBL) return("ASCII_TBL");
  else if (exttype == FitsFile::FitsExtensionType_BINARY_TBL) return("BINARY_TBL");
  else if (exttype == FitsFile::FitsExtensionType_EOF) return("EOF");
  else if (exttype == FitsFile::FitsExtensionType_ERROR) return("ERROR");
  else return("Unknown?");
}

string FITSDataType2String(FitsFile::FitsDataType datatype)
{
  if (datatype == FitsFile::FitsDataType_double) return("double");
  else if (datatype == FitsFile::FitsDataType_float) return("float");
  else if (datatype == FitsFile::FitsDataType_int) return("int");
  else if (datatype == FitsFile::FitsDataType_long) return("long");
  else if (datatype == FitsFile::FitsDataType_byte) return("byte");
  else if (datatype == FitsFile::FitsDataType_char) return("char");
  else if (datatype == FitsFile::FitsDataType_ASCII) return("ASCII");
  else if (datatype == FitsFile::FitsDataType_NULL) return("NULL");
  else return("Unknown?");
}

int main(int narg, char *arg[])
{
  if (narg < 2) {
    cerr << "scanfits/Erreur arg - Usage scanfits nomfits \n" << endl;
    exit(0);
  }
  try {
    SophyaInit();
    string flnm = arg[1];
    int nbblk = FitsInFile::NbBlocks(arg[1]);
    cout << " :::::::: File " << flnm << " has " << nbblk << " blocks " 
	 << " :::::::: " << endl;

    //    cout << " FitsFile::FitsExtensionType : FitsExtensionType_IMAGE= " <<
    //      (int)FitsFile::FitsExtensionType_IMAGE << 
    //      "  FitsExtensionType_ASCII_TBL= " << (int)FitsFile::FitsExtensionType_ASCII_TBL <<
    //      "  FitsExtensionType_BINARY_TBL= " << (int)FitsFile::FitsExtensionType_BINARY_TBL << endl;
    //    cout << " FitsFile::FitsDataType: FitsDataType_double= " <<
    //      (int)FitsFile::FitsDataType_double << 
    //      " FitsDataType_float= " << (int)FitsFile::FitsDataType_float <<
    //      " FitsDataType_int= " << (int)FitsFile::FitsDataType_int <<
    //      " FitsDataType_char= " << (int)FitsFile::FitsDataType_char <<
    //      " FitsDataType_ASCII= " << (int)FitsFile::FitsDataType_ASCII << endl << endl;

    for(int i=1; i<=nbblk; i++) {
      int naxis;
      vector<int> axis;
      DVList header;
      FitsFile::FitsExtensionType exttype;
      FitsFile::FitsDataType datatype;

      FitsInFile::GetBlockType(arg[1], i, exttype, naxis, axis, datatype, header);
      cout << "\n--------- Header Num " << i << " Type " << FITSExtType2String(exttype) 
	   << "  --- NAxis= " << naxis 
	   << " DataType= " << FITSDataType2String(datatype) << endl;
      if (axis.size() > 0) { 
	cout << " >> Axis Sizes: " ;
	for(int j=0; j<axis.size(); j++) { 
	  if (j > 0) cout << " x " ;
	  cout  << axis[j] ;
	}
	cout << endl;
      }
      cout << " >>> Header info : " ;
      cout << header << endl;
      cout << "----------------------------------------------------------------------" 
	   << endl;
    } 
 
  }
  catch (PThrowable & exc) {
    cerr << "sanfits: Catched Exception " << (string)typeid(exc).name()
         << "\n .... Msg= " << exc.Msg() << endl;
  }
  catch (...) {
    cerr << " some other exception was caught ! " << endl;
  }

}
