// This may look like C code, but it is really -*- C++ -*-

#ifndef SIMTOIPR_H
#define SIMTOIPR_H

#include "toiprocessor.h"

// ---------  Un deglitcheur simple
// Dans chaque fenetre de largeur de wsz
// if (val > Mean(Window)+ns*Sigma(Window)) val = Mean(Window)
// Si Pas plus de maxnpt points remplissants cette condition

class SimpleDeglitcher : public TOIProcessor {
public:
		SimpleDeglitcher(int wsz=64, double ns=3, int maxnpt=5);
  virtual	~SimpleDeglitcher();

  virtual void	init();  
  virtual void	run();

  inline int	WSize() const { return wsize; }
  inline double NbSigmas() const { return nsig; }
  inline int	MaxPoints() const { return maxpoints; }
  
  inline int	TotalSampleCount() const { return totnscount; }
  inline int	GlitchCount() const { return glcount; }
  inline int    GlitchSampleCount() const { return glnscount; }
  
protected:
  int totnscount;   // Nombre total d'echantillon processe
  int glnscount;    // Nombre total de glitch
  int glcount;      // Nombre de glitch detecte

  int wsize;        // Taille de fenetre de travail
  double nsig;      // Seuil en nb de sigmas 
  int maxpoints;    // Nb maxi de points > ns sigmas
};


//  Un filtre simple, dans le domaine temporel
//  remplace val -> Somme(val(i)*coeff(i)) ds Fenetre

class SimpleFilter : public TOIProcessor {
public:
  enum FilterKind {
    UserFilter=0,	// User defined filter function
    MeanFilter=1,       // Replace sample by the window mean value (lowpass)
    SumFilter=2,        // Replace sample by the window sum (lowpass)
    GaussFilter=3,      // Apply a gaussian to the window samples
    DiffFilter=4,	// value -= MeanValue
  };

		SimpleFilter(int wsz=128, 
			      FilterKind fk=SimpleFilter::MeanFilter,
		              double a=1., double s=1.);
  //		SimpleFilter(int wsz, Arr_DoubleFunctionOfX f=NULL);
		~SimpleFilter();

  inline FilterKind Type() { return fkind; }

  inline int	WSize() const { return wsize; }
  inline int	TotalSampleCount() const { return totnscount; }

  virtual void	init();  
  virtual void	run();

protected:
  FilterKind fkind;
  int totnscount;   // Nombre total d'echantillon processe
  int wsize;        // Taille de fenetre de travail
  double* coef;     // Coefficients du filtre 
  
};

#endif
