#include "piperiodmac.h"



/* --Methode-- */
PIPeriodMac::PIPeriodMac(int dt, UsPeriodicAction act, void * usp)
: Periodic(dt, act, usp), mLastTick(-1)
{
}

/* --Methode-- */
PIPeriodMac::~PIPeriodMac()
{
}

/* --Methode-- */
void PIPeriodMac::Start(int dt)
{
  StartRepeating();
  if (dt > 0)  { mDt = dt; mDtms = 1000*dt;}
}

/* --Methode-- */
void PIPeriodMac::Stop()
{
  StopRepeating();
}

/* --Methode-- */
void PIPeriodMac::SpendTime(const EventRecord&)
{
  long ticks = ::TickCount();
  if ((ticks - mLastTick) * 1000. / 60. < mDtms) return;
  mLastTick = ticks;
  DoPeriodic();
}
