//  Adaptateurs pour TMatrix TVector du package Sophya
//                             R. Ansari  1/99
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#include "pitvmaad.h"
#include <math.h>

/* --Methode-- */
template <class T> 
POTVectorAdapter<T>::POTVectorAdapter(TVector<T>* v, bool ad)
        : P1DArrayAdapter(v->NElts())
{
aDel = ad; 
mVec = v; 
}
/* --Methode-- */
template <class T> 
POTVectorAdapter<T>::~POTVectorAdapter()
{
if (aDel) delete mVec;
}

/* --Methode-- */
template <class T> 
double POTVectorAdapter<T>::Value(int i)
{
return((*mVec)(i));
}

/* --Methode-- */
double POTVectorAdapter< complex<float> >::Value(int i)
{
double re,im;
re = (*mVec)(i).real();
im = (*mVec)(i).imag();
return(sqrt(re*re+im*im));
}

/* --Methode-- */
double POTVectorAdapter< complex<double> >::Value(int i)
{
double re,im;
re = (*mVec)(i).real();
im = (*mVec)(i).imag();
return(sqrt(re*re+im*im));
}

/* --Methode-- */
template <class T> 
POTMatrixAdapter<T>::POTMatrixAdapter(TMatrix<T>* mtx, bool ad)
        : P2DArrayAdapter(mtx->NCols(), mtx->NRows())
{
aDel = ad; 
mMtx = mtx;
}
/* --Methode-- */
template <class T> 
POTMatrixAdapter<T>::~POTMatrixAdapter()
{
if (aDel)  delete mMtx;
}
/* --Methode-- */
template <class T> 
double POTMatrixAdapter<T>::Value(int ix, int iy)
{
return((double)(*mMtx)(iy, ix));
}

/* --Methode-- */
double POTMatrixAdapter< complex<float> >::Value(int ix, int iy)
{
double re,im;
re = (*mMtx)(iy, ix).real();
im = (*mMtx)(iy, ix).imag();
return(sqrt(re*re+im*im));
}

/* --Methode-- */
double POTMatrixAdapter< complex<double> >::Value(int ix, int iy)
{
double re,im;
re = (*mMtx)(iy, ix).real();
im = (*mMtx)(iy, ix).imag();
return(sqrt(re*re+im*im));
}

#ifdef __CXX_PRAGMA_TEMPLATES__
#pragma define_template POTVectorAdapter< int_4 >
#pragma define_template POTVectorAdapter< int_8 >
#pragma define_template POTVectorAdapter< float >
#pragma define_template POTVectorAdapter< double >
#pragma define_template POTVectorAdapter< complex<float> > 
#pragma define_template POTVectorAdapter< complex<double> > 

#pragma define_template POTMatrixAdapter< int_4 >
#pragma define_template POTMatrixAdapter< int_8 >
#pragma define_template POTMatrixAdapter< float >
#pragma define_template POTMatrixAdapter< double >
#pragma define_template POTMatrixAdapter< complex<float> > 
#pragma define_template POTMatrixAdapter< complex<double> > 
#endif

#if defined(ANSI_TEMPLATES)
template class POTVectorAdapter< int_4 >;
template class POTVectorAdapter< int_8 >;
template class POTVectorAdapter< float >;
template class POTVectorAdapter< double >;
template class POTVectorAdapter< complex<float> >;
template class POTVectorAdapter< complex<double> >;

template class POTMatrixAdapter< int_4 >;
template class POTMatrixAdapter< int_8 >;
template class POTMatrixAdapter< float >;
template class POTMatrixAdapter< double >;
template class POTMatrixAdapter< complex<float> >;
template class POTMatrixAdapter< complex<double> >;
#endif
