#ifndef FITSSPHEREHEALPIX_SEEN
#define FITSSPHEREHEALPIX_SEEN


// Guy Le Meur 03/2000


#include "spherehealpix.h"
#include "anydataobj.h"
#include "fitsfile.h"

namespace SOPHYA {
///////////////////////////////////////////////////////////////////////
// ------------- Classe pour la gestion de persistance I/O format fits--
// spherehealpix
//////////////////////////////////////////////////////////////////////
template <class T>
class FITS_SphereHEALPix : public FitsIOHandler  
{
public:

FITS_SphereHEALPix();
FITS_SphereHEALPix(char inputfile[],int hdunum=0); 
FITS_SphereHEALPix(const SphereHEALPix<T>& obj);
FITS_SphereHEALPix(SphereHEALPix<T>* obj);
virtual ~FITS_SphereHEALPix();
virtual AnyDataObj* DataObj();
virtual void        SetDataObj(AnyDataObj & o);

void Mollweide_picture_projection(char flnm[]);
void sinus_picture_projection(char flnm[]);
 void ReWriteFromFitsToFits(FitsInFile& headerin, FitsOutFile& os); 


inline operator SphereHEALPix<T>() { return(*dobj_); }

protected:

//virtual void ReadFromFits(FitsFile& fn);
virtual void ReadFromFits(FitsInFile& is);
virtual void WriteToFits(FitsOutFile& os) ;
SphereHEALPix<T>* dobj_;
bool ownobj_;
};


//////////////////////////////////////////////////////////////////

template <class T>
inline FitsOutFile& operator << (FitsOutFile& fios, SphereHEALPix<T> & sph)
  { FITS_SphereHEALPix<T> fih(&sph); fih.Write(fios); return (fios); }

template <class T>
inline FitsInFile& operator >> (FitsInFile& fiis, SphereHEALPix<T> & sph)
  { FITS_SphereHEALPix<T> fih(&sph); fih.Read(fiis); return (fiis); }


} // Fin du namespace

#endif
