#include "pierrdisp.h"
#include "utils.h"


PIErrorBox::PIErrorBox(PIContainerGen* par, int sx, int sy,
	     int px, int py)
: PIBaseWdg(par, "Error Message", sx, sy, px, py)
{
  currErrText = "";
  state = 0;
}

PIErrorBox::~PIErrorBox()
{
}

void
PIErrorBox::Draw()
{
  if (currErrText == "") {
    SelBackground();
    EraseWindow();
  } else {
    switch(state) {
    case 0:
      EraseWindow();
      SelForeground(PI_Red);
      DrawFBox(0,0,1000,1000);
      SelForeground(PI_Black);
      break;
    default:
      SelBackground();
      SelForeground();
    }
    SelFont(PI_BigSizeFont, PI_BoldFont);
    DrawString(20,30,(char*)currErrText.c_str());
  }
}

void
PIErrorBox::Cycle()
{
  state = (state + 1) % 2;
}




PIErrorDisplay::PIErrorDisplay(PIContainerGen* par, int sx, int sy,
			       int px, int py)
: PIContainer(par, "Error Display", sx, sy, px, py), PIPeriodX(1)
{
  currErrId = 0;

  errorBox  = new PIErrorBox(this, 150, 80, 0, 0);
  ackButton = new PIButton(this, "OK", 5000, 40, 20, 155, 20);
  updButton = new PIButton(this, "Upd", 5001, 40, 20, 155, 50);
  Start();
}

PIErrorDisplay::~PIErrorDisplay()
{
  delete updButton;
  delete ackButton;
  delete errorBox;
}

void
PIErrorDisplay::Process(PIMessage msg, PIMsgHandler *sender, void *data)
{
msg = UserMsg(msg);
  switch(msg) {
  case 5000:
    // On valide
    if (currErrId) 
      AcqAckError(currErrId);
    UpdData();
    break;
  case 5001:
    UpdData();
    break;
    
  default:
    PIContainer::Process(msg, sender, data);
  }
}

void
PIErrorDisplay::UpdData()
{
  currErrId = 0;
  char tache[80];
  char msg[200];
  int code;
  int severite;
  int rc = AcqGetNextError(&currErrId, tache, &code, &severite, msg);
  if (rc)
    errorBox->SetText("");
  else
    errorBox->SetText(string(tache) + " : (" + itos(code) + "/" +
		     itos(severite) +") " + msg);
  errorBox->Draw();
}


