#pragma once

#include <string>
#include <LTableView.h>
#include "pimsghandler.h"

class LArray;

struct PIPPListCell {
   string 	   str;
   PIMessage   msg;
};

class PIPPList : public LTableView {
public:

  PIPPList(PIMsgHandler* hndl);
  PIPPList(
    const SPaneInfo& inPaneInfo,
    const SViewInfo& inViewInfo,
    PIMsgHandler* hndl);
  virtual ~PIPPList();

  void       AppendItem(string const& str, PIMessage msg);
  void       DeleteItem(string const& str);
  void       DeleteItem(PIMessage msg);  

  void       SetMultipleSelect(bool ms);
  
  int        GetNbSel();
  PIMessage  GetSelMsg(int i);
  string     GetSelStr(int i);
  
  void       SelectItem(string const& str);
  void       SelectItem(PIMessage msg);
  void       ClearSelItem(string const& str);
  void       ClearSelItem(PIMessage msg);
  
protected:
  LTableSelector* tss;
  LTableSelector* tms;
  LArray*         mArray;
  PIMsgHandler*   mHndl;

  virtual void    ClickCell(
                       const STableCell        &inCell,
                       const SMouseDownEvent   &inMouseDown);

  void InitPPList();
  STableCell  FindMsg(PIMessage msg);
  STableCell  FindStr(string const& str);
};
