#include <stdio.h>
#include "pihisto.h"
#include "hisprof.h"

PIHisto::PIHisto(Histo* histo, bool ad)
: PIDrawer(), mHisto(histo)
{
  mAdDO = ad;     // Flag pour suppression automatique de mHisto
}

PIHisto::~PIHisto()
{
  if (mAdDO) delete mHisto;
}

void
PIHisto::UpdateLimits()
{
  if (!mHisto)  return;
  float hmin = mHisto->VMin();
  float hmax = mHisto->VMax()+0.2*(mHisto->VMax()-mHisto->VMin());
  // si HBProf min,max calcules en tenant compte des erreurs
  if( mHisto->ClassId() == HProf::classId ) {
    float v1,v2;
    for (int i=1; i<mHisto->NBins(); i++) {
      v1 = (*mHisto)(i) - mHisto->Error(i);
      v2 = (*mHisto)(i) + mHisto->Error(i);
      if(v1<hmin) hmin = v1;
      if(v2>hmax) hmax = v2;
    }
    v1 = 0.1*(hmax-hmin);
    hmin -= v1;   hmax += v1;
  }
  if(hmax<=hmin) hmax += 1.;
  SetLimits(mHisto->XMin(), mHisto->XMax(), hmin, hmax);
  SetAxesFlags(kBoxAxes | kExtTicks | kLabels);
}

void
PIHisto::Draw(PIGraphicUC* g, float /*xmin*/, float /*ymin*/, float /*xmax*/, float /*ymax*/)
{
  bool oktrace = false;
  if (!mHisto)  return;  
  if (mMrk != PI_NotDefMarker || mHisto->ClassId() == HProf::classId ) {
    // Marqeurs definis OU HBProf => marqueurs+Erreurs si il y en a
    if (mLAtt == PI_NotDefLineAtt) g->SelLine(PI_ThinLine);
    float x1,y1, x2,y2;
    float bw = mHisto->BinWidth();
    for (int i=0; i<mHisto->NBins(); i++) {
      if(mHisto->Error(i)>0.) {
        // barres d'erreur verticales
        x1 = x2 = mHisto->BinCenter(i);
        y1 = (*mHisto)(i) - mHisto->Error(i);
        y2 = (*mHisto)(i) + mHisto->Error(i);
        g->DrawLine(x1,y1, x1, y2);
        // limites de barres d'erreurs (horizontales)
        x1 -= bw/3.;  x2 += bw/3.;
        g->DrawLine(x1,y1, x2, y1);
        g->DrawLine(x1,y2, x2, y2);
      }
      // le marqueur
      x1 = mHisto->BinCenter(i);
      y1 = (*mHisto)(i);
      g->DrawMarker(x1,y1);
    }
    oktrace = true;
  }
  if (mLAtt != PI_NotDefLineAtt) {
    float x1,y1, x2, y2;
    x1 = mHisto->BinLowEdge(0);
    y1 = 0;
    for (int i=0; i<mHisto->NBins(); i++) {
      x2 = x1;
      y2 = (*mHisto)(i);
      g->DrawLine(x1,y1, x2, y2);
      y1 = y2;
      x2 = mHisto->BinHighEdge(i);
      g->DrawLine(x1,y1, x2, y2);
      x1 = x2;
    }
    y2 = 0; g->DrawLine(x1,y1, x2, y2);
    oktrace = true;
  }
  if( !oktrace ) {
    for(int i=0; i<mHisto->NBins(); i++) {
      float left   = mHisto->BinLowEdge(i);
      float width  = mHisto->BinWidth();
      float bottom = 0;
      float height = (*mHisto)(i);
      g->DrawFBox(left,bottom,width,height);
      g->DrawLine(left, bottom, left, bottom + height); // Au moins une ligne...
    }
  }
  DrawStats(g);
}

void
PIHisto::DrawStats(PIGraphicUC* g)
{
  if (!mHisto) return;
  if (mLAtt == PI_NotDefLineAtt)  g->SelLine(PI_ThinLine);
  float cellHeight = (YMax() - YMin()) * 0.05;
  float cellWidth  = (XMax() - XMin()) * 0.23;
  g->DrawLine(XMax() - cellWidth, YMax(),
                       XMax() - cellWidth, YMax() - cellHeight);
  g->DrawLine(XMax() - cellWidth, YMax() - cellHeight,
                       XMax()            , YMax() - cellHeight);
  char label[50];
  sprintf(label, "N = %.6g", mHisto->NData());
  g->SelFontSz((YMax() - YMin())/30);
  g->DrawString(XMax() - cellWidth*0.9, YMax() - cellHeight*0.8, label);
                       
}

