#include <unistd.h>
#include <stdexcept>
#include "toi.h"
#include "toiprocessor.h"
#include "fitstoirdr.h"
#include "fitstoiwtr.h"
#include "toisqfilter.h"
#include "toimanager.h"
#include "simtoipr.h"
#include "toiseqbuff.h"
#include "timing.h"
#include "sambainit.h"

void Usage(bool fgerr)
{
  cout << endl;
  if (fgerr) {
    cout << " simtst : Argument Error ! tstrztoi -h for usage " << endl; 
    exit(1);
  }
  else {
    cout << "\n Usage : simtst [-sproc] [-rwtoi] [-dbg] [-start snb] [-end sne] \n" 
	 << "         [-w1 sz] [-w2 sz] inFitsName outFitsName ppfFileName \n" 
	 << "   -sproc : Run RzSimpleTOIProc (default RzTOIProc) \n"
	 << "   -rwtoi : Use Regular Window TOI (default TOISeqBuffered) \n" 
	 << "   -dbg : sets TOISeqBuffered debug level to 1 \n"
	 << "   -start snb : sets the start sample num \n"
	 << "   -end sne : sets the end sample num \n"
	 << "   -range min,max : sets the acceptable range for intoi \n"
	 << "              default= -16000,16000\n"
	 << "   -intoi toiName : select input TOI name (def boloMuV_11)\n"
	 << "   -w1 sz : sets main data window size (def= 8192)\n"
	 << "   -w2 sz : sets secondary window size (def= 512) \n"
	 << endl;
    exit(0);
  }
}

int main(int narg, char** arg) {

  if ((narg > 1) && (strcmp(arg[1],"-h") == 0) ) Usage(false);

  cout << "simtst starting - Decoding arguments " << " narg=" << narg << endl;

  bool fgsimple = false;
  bool fgrwtoi = false;
  bool fgdbg = false;
  int w1 = 8192;
  int w2 = 256;
  int nmax = 10;
  int istart = 104121000+w1*5;
  int iend = 0;
  double range_min = -16000;
  double range_max = 16000.;
  string infile;
  string outfile;
  string ppffile;
  string intoi = "boloMuV_11";

  if (narg < 4) Usage(true);
  int ko=1;
  // decoding arguments 
  for(int ia=1; ia<narg; ia++) {
    if (strcmp(arg[ia],"-start") == 0) {
      if (ia == narg-1) Usage(true);  // -start est suivi d'un argument 
      istart = atoi(arg[ia+1]); ia++;
    }    
    else if (strcmp(arg[ia],"-end") == 0) {
      if (ia == narg-1) Usage(true);  
      iend = atoi(arg[ia+1]); ia++;
    }    
    else if (strcmp(arg[ia],"-w1") == 0) {
      if (ia == narg-1) Usage(true);  
      w1 = atoi(arg[ia+1]); ia++;
    }    
    else if (strcmp(arg[ia],"-w2") == 0) {
      if (ia == narg-1) Usage(true);  
      w2 = atoi(arg[ia+1]); ia++;
    }    
    else if (strcmp(arg[ia],"-range") == 0) {
      if (ia == narg-1) Usage(true);
      sscanf(arg[ia+1],"%lf,%lf",&range_min, &range_max);
      ia++;
    }    
    else if (strcmp(arg[ia],"-intoi") == 0) {
      if (ia == narg-1) Usage(true);  
      intoi = arg[ia+1]; ia++;
    }    
    else if (strcmp(arg[ia],"-sproc") == 0)  fgsimple = true;
    else if (strcmp(arg[ia],"-rwtoi") == 0)  fgrwtoi = true;
    else if (strcmp(arg[ia],"-dbg") == 0)  fgdbg = true;

    else { ko = ia; break; }  // Debut des noms
  }

  if (iend < istart) iend = istart+w1*(nmax+5);
  if ((narg-ko) < 3)  Usage(true); 
  infile = arg[ko];
  outfile = arg[ko+1];
  ppffile = arg[ko+2];

  cout << " Initializing SOPHYA ... " << endl;
  SophyaInit();
  InitTim();

  cout << ">>>> tstrztoi: Infile= " << infile << " outFile=" << outfile 
       << " ppfFile= " << ppffile << endl;
  cout << ">>>> Window Size W1= " << w1 << " W2= " << w2
       << "  iStart= " << istart << " iEnd= " << iend << endl;
  cout << ">>>> InTOIName= " << intoi << endl;
  try {
    TOIManager* mgr = TOIManager::getManager();
  
    //  mgr->setRequestedSample(11680920,11710584);
    //  mgr->setRequestedSample(104121000, 104946120);

    mgr->setRequestedSample(istart, iend);
  
    //    FITSTOIReader r("/data/Archeops/bolo11.fits); 
    FITSTOIReader r(infile); 
    cout << "reader created" << endl;
    //    FITSTOIWriter w("/data/Archeops/rz.fits");
    FITSTOIWriter w(outfile);
    cout << "fits writer created" << endl;


    //    char * colname[5] = {"MJD", "UTC","boloMuV_11","magnFlux","pivot"};
    //    char * toiname[5] = {"MJD", "UTC","bolo11","magneto","pivot"};
    TOISeqBuffered * toiin = new TOISeqBuffered("f2in", w1);
    if (fgdbg) toiin->setDebugLevel(1);
    TOISeqBuffered * toiout = new TOISeqBuffered("out", w1);
    if (fgdbg) toiout->setDebugLevel(1);
    TOISeqBuffered * toimean = new TOISeqBuffered("mean", w1);
    if (fgdbg) toimean->setDebugLevel(1);
    TOISeqBuffered * toisig = new TOISeqBuffered("sigma", w1);
    if (fgdbg) toisig->setDebugLevel(1);
    TOISeqBuffered * toiincopie = new TOISeqBuffered("incopie", w1);
    if (fgdbg) toiincopie->setDebugLevel(1);
    
  

    // Connecting TOI to FITSTOIReader Processor
    //    for(kk=0; kk<5; kk++) {
    //      r.addOutput(colname[kk], toitab[kk]);
    //    }

    //    int kk = 2;
    r.addOutput(intoi, toiin);
    //  toi->dbg=true;
    //  r.addOutput("boloMuV_11", toi);
    cout << " connecting in/out to RzTOIProcessor ... " << endl;

    //    TOIProcessor * filt = NULL;

    cout << " Creating SimpleDeglitcher() " << endl;
    SimpleDeglitcher degl(w2);
    cout << " Setting Range for deglitcher: " << range_min 
	 << " - " << range_max << endl;
    degl.SetRange(range_min, range_max);
    degl.addInput("in", toiin);
    degl.addOutput("out", toiout);
    degl.addOutput("mean", toimean);
    degl.addOutput("sigma", toisig);
    degl.addOutput("incopie", toiincopie);
 
    /*   
    cout << " Creating a GaussianFilter SimplFilterObject " << endl;
    SimpleFilter filt(..)
    TOISeqBuffered * toiincopie = new TOISeqBuffered("incopie", w1);
    if (fgdbg) toiincopie->setDebugLevel(1);
    */

    w.setOutFlags(true);
    w.addInput("in", toiincopie);
    w.addInput("degli", toiout);
    w.addInput("mean", toimean);
    w.addInput("sigma", toisig);

    cout << " ------ FITSReaderTOI::PrintStatus() : ----- " << endl;
    r.PrintStatus(cout);  
    cout << "----- FITSWriterTOI::PrintStatus() : ----- " << endl;
    w.PrintStatus(cout);  

    PrtTim("starting threads");
    r.start();
    degl.start();
    w.start();

    /*    
    for(int jj=0; jj<3; jj++) {
      cout << *toiin; 
      cout << *toiout; 
      sleep(1);
    }
    */

    mgr->joinAll();
    PrtTim("End threads");

    //    cout << " ------ FITSReaderTOI::PrintStatus() : ----- " << endl;
    //    r.PrintStatus(cout);  
    //    cout << "----- FITSWriterTOI::PrintStatus() : ----- " << endl;
    //    w.PrintStatus(cout);  

    cout << degl;
    cout << " ------ toiin and toiout Status information ------- " << endl;
    cout << *toiin; 
    cout << *toiout;
  }
  catch (PThrowable & exc) {
    cerr << "\nrztsttoi: Catched Exception \n" << (string)typeid(exc).name() 
	 << " - Msg= " << exc.Msg() << endl;
  }
  catch (const std::exception & sex) {
    cerr << "\nrztsttoi: Catched std::exception \n" 
	 << (string)typeid(sex).name() << endl; 
  }
  catch (...) {
    cerr << "\nrztsttoi: some other exception was caught ! " << endl;
  }

  return(0);
}
