#include <math.h>

/* @(#) $Id: actan.c,v 1.1.1.1 2001-04-10 14:40:45 cmv Exp $ */

double
actan(double sinx, double cosx)
{
    double ret;

    ret = 0.0;
    if(cosx < 0.0) {
	ret = M_PI;
    } else if(cosx == 0.0) {
	if(sinx < 0.0) {
	    return 3.0 * M_PI_2;
	} else if(sinx == 0.0) {
	    return ret;
	} else /* sinx > 0.0 */ {
	    return M_PI_2;
	}
    } else /* cosx > 0.0 */ {
	if(sinx < 0.0) {
	    ret = 2.0 * M_PI;
	} else if(sinx == 0.0) {
	    return ret;
	}
    }

    return ret + atan(sinx / cosx);
}


#if 0

#define D(X) (180.0 * (X) / M_PI)

void main() {
    double a, b;

    a =  0.0; b =  2.0; printf("actan(%f, %f) = %f\n", a, b, D(actan(a, b)));
    a =  1.0; b =  2.0; printf("actan(%f, %f) = %f\n", a, b, D(actan(a, b)));
    a =  2.0; b =  2.0; printf("actan(%f, %f) = %f\n", a, b, D(actan(a, b)));
    a =  2.0; b =  1.0; printf("actan(%f, %f) = %f\n", a, b, D(actan(a, b)));
    a =  2.0; b =  0.0; printf("actan(%f, %f) = %f\n", a, b, D(actan(a, b)));
    a =  2.0; b = -1.0; printf("actan(%f, %f) = %f\n", a, b, D(actan(a, b)));
    a =  2.0; b = -2.0; printf("actan(%f, %f) = %f\n", a, b, D(actan(a, b)));
    a =  1.0; b = -2.0; printf("actan(%f, %f) = %f\n", a, b, D(actan(a, b)));
    a =  0.0; b = -2.0; printf("actan(%f, %f) = %f\n", a, b, D(actan(a, b)));
    a = -1.0; b = -2.0; printf("actan(%f, %f) = %f\n", a, b, D(actan(a, b)));
    a = -2.0; b = -2.0; printf("actan(%f, %f) = %f\n", a, b, D(actan(a, b)));
    a = -2.0; b = -1.0; printf("actan(%f, %f) = %f\n", a, b, D(actan(a, b)));
    a = -2.0; b =  0.0; printf("actan(%f, %f) = %f\n", a, b, D(actan(a, b)));
    a = -2.0; b =  1.0; printf("actan(%f, %f) = %f\n", a, b, D(actan(a, b)));
    a = -2.0; b =  2.0; printf("actan(%f, %f) = %f\n", a, b, D(actan(a, b)));
    a = -1.0; b =  2.0; printf("actan(%f, %f) = %f\n", a, b, D(actan(a, b)));
}

#endif /* 0 */

/* For RCS Only -- Do Not Edit */
static char *rcsid[2] = {(char *)rcsid, "@(#) $RCSfile: actan.c,v $ $Date: 2001-04-10 14:40:45 $ $Revision: 1.1.1.1 $ $Name: not supported by cvs2svn $"};
