#include "fitstoiwtr.h"
#include "toimanager.h"



extern void fits_lock();
extern void fits_unlock();

FITSTOIWriter::FITSTOIWriter(string fn) {
  fname = fn;
  fstatus = 0;
  outFlags = false;

  // Open file
  remove(fname.c_str()); 
  fits_lock();
  fits_create_file(&fptr,fname.c_str(),&fstatus);
  fits_unlock();
  name = "wtr";
}

FITSTOIWriter::~FITSTOIWriter() {
}

void FITSTOIWriter::setOutFlags(bool yn) {
  outFlags = yn;
}

void FITSTOIWriter::addInput(string name, TOI* toi) {
  declareInput(name);
  fwinputs.push_back(toi);
}

void FITSTOIWriter::afterinit()
{
  if (inTOIs) delete[] inTOIs;
  inTOIs = new (TOI*[fwinputs.size()]);

  for (int i=0; i<fwinputs.size(); i++) {
    inTOIs[i] = fwinputs[i];
  }
  
}

void FITSTOIWriter::run() {
  cout << "fitstoiwriter running" << endl;
  // init done here
  afterinit();
  inited=true;

  int ndata = inIx.size();
  int ncols = inIx.size() * (outFlags ? 2 : 1) + 1;

  char** colnames = new (char*[ncols]);
  char** coltypes = new (char*[ncols]);
  char** colunits = new (char*[ncols]);

  colnames[0] = "samplenum";
  coltypes[0] = "1D";
  colunits[0] = "integer";

  cout << " FITSTOIWriter::run() - Creating output FITS file: "
       << name << endl;

  vector<string> coln;
  int ck=0;
  for (map<string, int>::iterator ii = inIx.begin(); ii != inIx.end(); ii++) {
    int j = (*ii).second;
    coln.push_back((*ii).first);
    if (outFlags) j += j;
    colnames[j+1] = const_cast<char*>(coln[ck].c_str());  
    cout << " Column[" << j+1 << "] Name=" << coln[ck] << endl;
    ck++;
    coltypes[j+1] = "1D";
    colunits[j+1] = "double";
    if (outFlags) {
      coln.push_back("fg_" + coln[ck-1]); 
      colnames[j+2] = const_cast<char*>(coln[ck].c_str());  
      cout << " Column[" << j+1 << "] -Flag- Name=" << coln[ck] << endl;
      ck++;
      coltypes[j+2] = "1D";
      colunits[j+2] = "IntFlag";
    }
  }

  fits_lock();
  fits_create_tbl(fptr, BINARY_TBL, 0, ncols, colnames, coltypes, colunits, NULL, &fstatus);
  fits_write_date(fptr, &fstatus);
  fits_unlock();

  delete[] colunits;
  delete[] coltypes;
  delete[] colnames;

  // Add headers ?

  // loop

  int fitsLine = 1;
  int snb = getMinIn();
  int sne = getMaxIn();

  double* tabdata = new double[ndata];
  double* tabflag = new double[ndata]; // ? pas integer ?? $CHECK$ - Reza
  bool* tabck = new bool[ndata];
  int i;
  for(i=0; i<ndata; i++) {
    tabdata[i] = -9.e19;  // $CHECK$ - Reza valeur par defaut !
    tabflag[i] = -9.e19;  // $CHECK$ - Reza valeur par defaut !
    tabck[i] = checkInputTOIIndex(i);
  } 

  for (int sn = snb; sn <= sne; sn++) {
    //    if ((sn%2000 == 0) || (sn<snb+5)) 
    //  cout << " DBG-A-FitsWriter::run()" << sn << endl;
    try {
      int_4 out_flg;
      double out_val;
      for (i=0; i<ndata; i++) {
	if (tabck[i]) {
	  getData(i,sn, out_val, out_flg);
	  tabdata[i] = out_val;
	  if (outFlags) tabflag[i] = out_flg;
	}
      }
      fits_lock();
      //      if ((sn%2000 == 0) || (sn<snb+5)) 
      //cout << " DBG-B-FitsWriter::run()" << sn << endl;
      double xx = sn;
      fits_write_col_dbl(fptr, 1, fitsLine, 1, 1, &xx, &fstatus);
      
      for (i=0; i<ndata; i++) {
	if (outFlags) {
	  fits_write_col_dbl(fptr, 2*i+2, fitsLine, 1, 1, tabdata+i, &fstatus);
	  fits_write_col_dbl(fptr, 2*i+3, fitsLine, 1, 1, tabflag+i, &fstatus);
	} else {
	  fits_write_col_dbl(fptr, i+2, fitsLine, 1, 1, tabdata+i, &fstatus);
	}
	if (fstatus != 0) {
	  cerr << "fitstoiwtr error sn = " << sn << " i = "<< i << endl;
	  fits_report_error(stderr, fstatus);
	  abort();
	}
      }
      fits_unlock();
      //           if ((sn%2000 == 0) || (sn<snb+5)) 
      //      	cout << " DBG-C-FitsWriter::run()" << sn << " line=" << fitsLine << endl;
      fitsLine++;
    } catch (PException e) {
    cout << "fitstoiwtr exception " << e.Msg() << endl;
    continue;
    }
  }

  delete[] tabdata;
  delete[] tabflag;
  delete[] tabck;

  fits_lock();
  fits_close_file(fptr, &fstatus);
  fits_report_error(stderr, fstatus);
  fits_unlock();
  cout << "fitstoiwriter done fitsLine= " << fitsLine << endl;
}








