#include "array.h"
#include "rztoi.h"
#include "toimanager.h"
#include "pexceptions.h"
#include "fftpserver.h"
#include "ctimer.h"

RzTOIProc::RzTOIProc(int w1, int w2, int nmax)
{
  cout << "RzTOIProc::RzTOIProc() Width= " << w1 << "," << w2 << " NMax=" << nmax;
  _width1 = w1;
  _width2 = w2;
  _nmax = nmax;
}

void RzTOIProc::init() {
  cout << "RzTOIProc::init" << endl;
  declareInput("in");
  declareOutput("out");
  name = "rzproc";
  upExtra = 1;
}

void RzTOIProc::run() {
  //  TOIManager* mgr = TOIManager::getManager();
  int snb = getMinIn();
  int sne = getMaxIn();

  int istart, iend;
  int ilast;
  ilast = istart = snb; 
  iend = sne;
  int ii, jj;

  try {
    Timer tm("RzTOIProc::run()");

    FFTPackServer ffts;

    bool fgppf = false;
    int nkv = 0;
    //    int nkvmx = 8;
#define nkvmx 8 
    Vector vkin[nkvmx];
    Vector vkout[nkvmx];
    TVector< complex<r_8> > vkfft[nkvmx];
    if (outppf.length() > 0)    fgppf = true;
    
    Vector vin, vout, vsave(_width2);
    TVector< complex<r_8> > vfft;
    double vlast = 0.;

    for (int k=0; k<_nmax; k++) {
      //      istart = snb + k*_width1;
      istart = snb + k*_width1 - k*_width2;
      iend = istart +_width1;
      cout << "---RzTOIProc::run() - Processing bloc k= " << k 
	   << " istart= " << istart << " iend= " << iend << endl;
      if (iend > sne) {
	cout << " RzTOIProc::run() - iend > getMaxIn() -> break " << endl;
	break;
      }
      //      Vector vin = getData(0, istart, iend);
      vin.ReSize(_width1);
      if (k == 0) {
	jj = 0;
	for(ii=istart; ii<iend; ii++)  
	  vin(jj++) = getData(0, ii);
      }
      else {
	vin(Range(0,-1,_width2)) = vsave;
	jj = _width2;
	for(ii=istart+_width2; ii<iend; ii++)  
	  vin(jj++) = getData(0, ii);
      }

      vsave = vin(Range(_width1-_width2, -1,_width2));
      cout << "> End of getData() for bloc " << k << endl;

      vout.ReSize(vin.Size());
      //      cout << " DBG : Bloc[" << k << "] FirstSN=" << istart
      //	   << " LastSN= " << istart+vout.Size()-_width2-1 << endl;
      for(int i=0; i<vout.Size()-_width2; i++) {
	vout(i) = vin(Range(i,-1,_width2)).Sum()/(r_8)_width2;
	putData(0, i+istart, vout(i));
	vlast = vout(i);
      }

      for(int i=vout.Size()-_width2; i<vout.Size(); i++) {
	vout(i) = vlast;
	//	putData(0, i+istart, vout(i));
      }

      cout << ">> End of putData() for bloc[" << k << "] FirstSN=" 
	   << istart << " LastSN= " << istart+vout.Size()-_width2-1 
	   << " Mean vout= " << vout.Sum()/vout.Size() << endl;

      vin -= vout;

      TVector< complex<r_8> > vfft;
      ffts.FFTForward(vin, vfft);
      ilast = iend;
      /*
      if (fgppf) {
	string nom;
	nom = "in" + (string)MuTyV(k);
	ppo->PutObject(vin, nom);
	nom = "out" + (string)MuTyV(k);
	ppo->PutObject(vout, nom);
	nom = "fft" + (string)MuTyV(k);
	ppo->PutObject(vfft, nom);
      }
      */
      if (fgppf && (nkv < nkvmx) ) {
	vkin[nkv] = vin;
	vkout[nkv] = vout;
	vkfft[nkv] = vfft;
	nkv++;
      }

      tm.Split("End of bloc");
    }

    if (fgppf) {
      cout << " Writing to Out PPF ... " << endl;
      POutPersist ppo(outppf);
      for(int kkk=0; kkk<nkv; kkk++) {
	string nom;
	nom = "in" + (string)MuTyV(kkk);
	ppo.PutObject(vkin[kkk], nom);
	nom = "out" + (string)MuTyV(kkk);
	ppo.PutObject(vkout[kkk], nom);
	nom = "fft" + (string)MuTyV(kkk);
	ppo.PutObject(vkfft[kkk], nom);
      }
    }

    cout << " Filling with flag!=0  : putData(0, ii, flag) ii: "
	 << iend << " .. " << sne << endl;
    for(ii=iend-_width2; ii<iend; ii++) {
      putData(0, ii, vlast, 1);
    }

    double xxx;
    for(ii=iend; ii<sne; ii++) {
      if ((ii-iend)%1000 == 0) 
	cout << " RzTOIProc::run() - Processing sample ii= " << ii
	     << endl;
      xxx=getData(0,ii);
      putData(0,ii,xxx,2);
    }

  }
  catch (PException & e) {
    cout << "RzTOIProc: Catched exception " << (string)typeid(e).name()
	 << "\n Msg= " << e.Msg() << endl;
  }
}



RzSimpleTOIProc::RzSimpleTOIProc(int wsz, double fact)
{
  if (wsz < 4) wsz = 4;
  cout << "RzSimpleTOIProc::RzSimpleTOIProc() factor= " << fact 
       << " WSize=" << wsz << endl; 
  _fact = fact;
  _wsz = wsz;
}

void RzSimpleTOIProc::init() {
  cout << "RzSimpleTOIProc::init" << endl;
  declareInput("in");
  declareOutput("out");
  name = "rzsimpleproc";
  upExtra = 1;
}

void RzSimpleTOIProc::run() {
  //  TOIManager* mgr = TOIManager::getManager();
  int snb = getMinIn();
  int sne = getMaxIn();

  int nstot = sne-snb;
  int nbloc = nstot/_wsz;
  cout << " RzSimpleTOIProc::run(): snb=" << snb << " sne=" 
       << sne << " NBloc=" << nbloc << endl;

  double val;
  int snlast = snb;
  int istart,ii,kb;
  try {
    Timer tm("RzSimpleTOIProc::run()");
    Vector vin(_wsz);
    for (kb=0; kb<nbloc; kb++) {
      istart = kb*_wsz+snb;
      if (kb%2 == 0) {  // On parcourt a l'envers
	cout << " ... Processing bloc[" << kb << "] (Reverse) SampleNum=" 
	     << istart+_wsz << " ->" << istart << endl;
	for(ii=_wsz-1; ii>=0; ii--)
	  vin(ii) = getData(0, ii+istart);
      }
      else {  // On parcourt vers l'avant 
	cout << " ... Processing bloc[" << kb << "] SampleNum=" 
	     << istart << " ->" << istart+_wsz << endl;
	for(ii=0; ii<_wsz; ii++)
	  vin(ii) = getData(0, ii+istart);	
      }
      for(ii=0; ii<_wsz; ii++)
	putData(0, ii+istart, vin(ii)*_fact);
      snlast = istart+_wsz;
    }
    cout << " ... Processing remaining Samples - SN=" 
	 << snlast << " ->" << sne << endl;
    for(ii=snlast; ii<=sne; ii++) {
      val = getData(0, ii);
      putData(0, ii, val*_fact);
    }
    
    
  }
  catch (PException & e) {
    cout << "RzSimpleTOIProc exception " << (string)typeid(e).name()
	 << "\n  Msg= " << e.Msg() << endl;
  }
}
