// This may look like C code, but it is really -*- C++ -*-
#ifndef MAP2TOI_H
#define MAP2TOI_H

#include "toiprocessor.h"
#include "spherehealpix.h"

//-- Un generateur de TOI a partir d'une sphere et de 2 TOIs alpha,delta
// Lecture de 2 TOI alpha,delta et d'une Sphere Healpix
// Sortie de 3 TOI alpha,delta,boloMuV
//
// Structure generale :
// (les alpha[0,360[,delta[-90,90] sont en degres decimaux)
//             Sphere ---- |
//                         |
//                    -----------
//   toi AlphaIn ---> |         | ---> toi AlphaOut
//                    | Map2TOI | ---> toi DeltaOut
//   toi DeltaIn ---> |         | ---> toi BoloOut
//                    -----------

class Map2TOI : public TOIProcessor {
public:
                 Map2TOI(SphereHEALPix<r_8>& sph);
  virtual	~Map2TOI();

  virtual void	init(void);  
  virtual void	run(void);
  
protected:
  SphereHEALPix<r_8>& mSph;
};

#endif
