// This may look like C code, but it is really -*- C++ -*-
#ifndef TOI2MAP_H
#define TOI2MAP_H

#include "toiprocessor.h"
#include "spherehealpix.h"

//-- Un projecteur de TOI sur une sphere Healpix
// Lecture de 3 TOI alpha,delta,boloMuV
// Sortie rien
//
// Structure generale :
// (les alpha[0,360[,delta[-90,90] sont en degres decimaux)
//                         |---->Sphere
//                         |
//                    -----------
//   toi AlphaIn ---> |         |
//   toi DeltaIn ---> | TOI2Map |
//   toi BoloIn  ---> |         |
//                    -----------

class TOI2Map : public TOIProcessor {
public:
                 TOI2Map(SphereHEALPix<r_8>* sph,SphereHEALPix<r_8>* wsph=NULL);
  virtual	~TOI2Map();

  virtual void	init(void);  
  virtual void	run(void);
  inline  void  SetCoorGal(bool fg=false,double actualyear=2000.)
                          {mTypCoor = fg; mActualYear = actualyear;}
  
protected:
  SphereHEALPix<r_8>* mSph;
  SphereHEALPix<r_8>* mWSph;
  bool mWSphInternal;
  bool mTypCoor;
  double mActualYear;
};

#endif
