// This may look like C code, but it is really -*- C++ -*-

#ifndef SIMTOIPR_H
#define SIMTOIPR_H

#include "toiprocessor.h"
#include "tvector.h"

// ---------  Un deglitcheur simple
// Dans chaque fenetre de largeur de wsz
// if (val > Mean(Window)+ns*Sigma(Window)) val = Mean(Window)
// Si Pas plus de maxnpt points remplissants cette condition

class SimpleDeglitcher : public TOIProcessor {
public:
		SimpleDeglitcher(int wsz=64, double ns=3, int maxnpt=5);
  virtual	~SimpleDeglitcher();

  inline void   SetRange(double min, double max)
    { range_min = min; range_max = max; }
  inline void   GetRange(double& min, double& max) const 
    { min = range_min; max = range_max; }

  virtual void	init();  
  virtual void	run();

  inline int	WSize() const { return wsize; }
  inline double NbSigmas() const { return nsig; }
  inline int	MaxPoints() const { return maxpoints; }
  
  inline int_8	ProcessedSampleCount() const { return totnscount; }
  inline int_8	GlitchCount() const { return glcount; }
  inline int_8  GlitchSampleCount() const { return glnscount; }
  inline int_8  OutOfRangeSampleCount() const { return out_range_nscount; }
  
  virtual void  PrintStatus(ostream & os) ; // const plus tard
  
protected:
  int_8 totnscount;   // Nombre total d'echantillon processe
  int_8 glnscount;    // Nombre total de glitch
  int_8 glcount;      // Nombre de glitch detecte
  int_8 out_range_nscount;  // Nombre de sample Out Of Range
  bool deglitchdone;  // Deglitch effectue

  int wsize;        // Taille de fenetre de travail
  double nsig;      // Seuil en nb de sigmas 
  int maxpoints;    // Nb maxi de points > ns sigmas
  double range_min, range_max;  // Range acceptable pour in
};


//  Un filtre simple, dans le domaine temporel
//  remplace val -> Somme(val(i)*coeff(i)) ds Fenetre

class SimpleFilter : public TOIProcessor {
public:
  enum FilterKind {
    UserFilter=0,	// User defined filter function
    MeanFilter=1,       // Replace sample by the window mean value (lowpass)
    SumFilter=2,        // Replace sample by the window sum (lowpass)
    GaussFilter=3,      // Apply a gaussian to the window samples
    DiffFilter=4,	// value -= MeanValue
  };

  static string FilterKind2String(FilterKind fk);
		SimpleFilter(int wsz=128, 
			     FilterKind fk=SimpleFilter::MeanFilter,
			     double a=1., double s=1.);
  		SimpleFilter(Vector const & vc);
		~SimpleFilter();

  inline FilterKind Type() { return fkind; }

  inline int	WSize() const { return wsize; }
  inline int_8	ProcessedSampleCount() const { return totnscount; }
  Vector        FilterCoefficients() const;

  virtual void  PrintStatus(ostream & os) ; // const plus tard

  virtual void	init();  
  virtual void	run();

protected:
  FilterKind fkind;
  int_8 totnscount;   // Nombre total d'echantillon processe
  int wsize;        // Taille de fenetre de travail
  double* coef;     // Coefficients du filtre 
  
};

//  Classe SimpleAdder
//  Calcule la sortie = Somme_Entree [ coeff[num] * entree[num] ]

class SimpleAdder : public TOIProcessor {
public:
		SimpleAdder(int nbinput); 
		~SimpleAdder();

  void          SetGain(int num, double g);
  double        Gain(int num);

  inline int	NbInput() const { return nb_input; }
  inline int_8	ProcessedSampleCount() const { return totnscount; }

  virtual void  PrintStatus(ostream & os) ; // const plus tard

  virtual void	init();  
  virtual void	run();

protected:
  int nb_input;
  Vector gains;
  int_8 totnscount;   // Nombre total d'echantillon processe
};


//  Classe SimpleFanOut
//  Transforme recopie chaque entree sur M lignes de sortie

class SimpleFanOut : public TOIProcessor {
public:
		SimpleFanOut(int nbinput, int mfanout); 
		~SimpleFanOut();

  inline int	NbInput() const { return nb_input; }
  inline int	MFanOut() const { return m_fanout; }
  inline int_8	ProcessedSampleCount() const { return totnscount; }

  virtual void  PrintStatus(ostream & os) ; // const plus tard

  virtual void	init();  
  virtual void	run();

protected:
  int nb_input;
  int m_fanout;
  int_8 totnscount;   // Nombre total d'echantillon processe
};

#endif
