#include <unistd.h>
#include <stdexcept>
#include "toi.h"
#include "toiprocessor.h"
#include "fitstoirdr.h"
#include "fitstoiwtr.h"
#include "toimanager.h"
#include "toiseqbuff.h"
#include "asciitoiwtr.h"

void usage(void);
void usage(void) {
 cout<<"fits2ascii [-h] [-s samplemin,samplemax] [-w data_window_size]"
     <<" fitsin asciiout"<<endl;
 return;
}

////////////////////////////////////////////////////////////////
int main(int narg, char** arg) {

TOIManager* mgr = TOIManager::getManager();

//-- Decodage arguments
long sdeb,sfin;
int width = 8192;
int c;
while((c = getopt(narg,arg,"hs:w:")) != -1) {
  switch (c) {
  case 's' :
    sscanf(optarg,"%ld,%ld",&sdeb,&sfin);
    cout<<"Requested Samples from "<<sdeb<<" , "<<sfin<<endl;
    if(sfin>=sdeb) mgr->setRequestedSample(sdeb,sfin);
    else {cout<<"Bad sample interval "<<endl; exit(-2);}
    break;
  case 'w' :
    sscanf(optarg,"%d",&width);
    if(width<=0) width=8192;
    cout<<"Data window size "<<width<<endl;
    break;
  case 'h' :
    usage(); exit(-1);
  }
}
if(optind+1>=narg) {usage(); exit(-2);}

/////////////////////////////////////
try {
  FITSTOIReader r(arg[optind]);
  ASCIITOIWriter w(arg[optind+1]);

  int ncol = r.getNOut();
  cout<<"Number of columns in fits file : "<<ncol<<endl;
  if(ncol<=0) exit(-3);

  TOISeqBuffered **toi = new TOISeqBuffered *[ncol];
  int i;
  for(i=0;i<ncol;i++) {
    string col = r.getOutName(i);
    toi[i] = new TOISeqBuffered(col,width);
    cout<<"...got TOI "<<col<<endl;
    r.addOutput(col,toi[i]);
    w.addInput(col,toi[i]);
  }

  r.start();
  w.start();

  mgr->joinAll();

  r.PrintStatus(cout);
  w.PrintStatus(cout);

  for(i=0;i<ncol;i++) if(toi[i]) delete toi[i];
  delete toi;

} catch (PThrowable & exc) {
  cout << "\nfits2ascii: Catched Exception \n" << (string)typeid(exc).name() 
       << " - Msg= " << exc.Msg() << endl;
} catch (const std::exception & sex) {
  cout << "\nfits2ascii: Catched std::exception \n" 
       << (string)typeid(sex).name() << endl; 
} catch (...) {
  cout << "\nfits2ascii: some other exception was caught ! " << endl;
}

return(0);
}
