// This may look like C code, but it is really -*- C++ -*-

#ifndef FITSTOIRDR_H
#define FITSTOIRDR_H

#include "toiprocessor.h"
#include <string>
#include <vector>
#include "fitsio.h"


class FITSTOIReader : public TOIProcessor {
public:
  FITSTOIReader(string fn);
  ~FITSTOIReader();

  virtual void addFile(string fn);

  virtual void init();  
  virtual void run();  

protected:
  virtual int   calcMinOut();
  virtual int   calcMaxOut();

  virtual void run1();
  virtual void openFile(string fn);

private:
  fitsfile* fptr;
  int       fstatus;
  string    fname;   // current file
  long      nrows;   // current file
  int       firstSn; // current file

  int       ncols;    
  int       snBegin; // first file
  int       snEnd;   // last file
  
  vector<string> allfn;

};


#endif
