/*   Test de processeurs ds simtoipr.cc   - Reza Avril 2001

----------------   Exemple d'appel  ---------------------
csh> simtst -start 104385384 -end 104399964 -range -500,500 \
            -intoi boloMuV_26 -wtoi 8192 -wdegli 1024 \
	    inputbolo.fits filt.fits xx.ppf
# Avec Filtre de Fourier
csh> simtst -start 104385384 -end 104399964 -range -500,500 \
            -intoi boloMuV_26 -wtoi 8192 -wdegli 1024 \
            -wfft 4096 -keepfft 5 -killfreq 15,4,2.5 \ 
	    inputbolo.fits filtfft.fits spectre.ppf
# Autre exemple b545k02
cool> ./simtst -start 104389122 -end 104649122 -range -1000.,1000. -intoi boloMu
V_23 -wtoi 8192 -wdegli 1024 -wfft 4096 -keepfft 5 -killfreq 15,4,2.5 Cmv/b545k02
2_16.00_16.49.fits b545.fits b545.ppf

*/



#include "machdefs.h"
#include <math.h>
#include "array.h"
#include <unistd.h>
#include <stdexcept>
#include "toi.h"
#include "toiprocessor.h"
#include "fitstoirdr.h"
#include "fitstoiwtr.h"
#include "toisqfilter.h"
#include "toimanager.h"
#include "simtoipr.h"
#include "toiseqbuff.h"
#include "timing.h"
#include "sambainit.h"

void Usage(bool fgerr)
{
  cout << endl;
  if (fgerr) {
    cout << " simtst : Argument Error ! simtst -h for usage " << endl; 
    exit(1);
  }
  else {
    cout << "\n Usage : simtst [-intoi toiname] [-start snb] [-end sne] \n" 
	 << "         [-dbg] [-wtoi sz] [-wdegli sz] [-range min,max] \n"
	 <<"          [-wfft sz] [-keepfft n] [-killfreq bf,nharm,sigf \n"
	 << "         inFitsName outFitsName  outPPFName \n" 
	 << "   -dbg : sets TOISeqBuffered debug level to 1 \n"
	 << "   -start snb : sets the start sample num \n"
	 << "   -end sne : sets the end sample num \n"
	 << "   -range min,max : sets the acceptable range for intoi \n"
	 << "              default= -16000,16000\n"
	 << "   -intoi toiName : select input TOI name (def boloMuV_27)\n"
	 << "   -wtoi sz : sets TOISeqBuff buffer size (def= 8192)\n"
	 << "   -wdegli sz : sets deglitcher window size (def= 512) \n"
	 << "   -wfft sz : Activate Fourier filter and sets its width \n"
	 << "   -keepfft n : Keeps n spectra (if Fourier filter activated) \n" 
	 << "   -killfreq bf,nharm,sigf : kills nharm frequency, basefreq=bf \n"
            "              with a gaussian with width=sigf \n" 
	 << endl;
    exit(0);
  }
}

int main(int narg, char** arg) {

  if ((narg > 1) && (strcmp(arg[1],"-h") == 0) ) Usage(false);

  cout << "simtst starting - Decoding arguments " << " narg=" << narg << endl;

  bool fgdbg = false;
  bool fgsetstart = false;
  int wtoi = 8192;
  int wdegli = 512;
  int wfft = 4096;
  int keepfft = 0;
  int nmax = 10;
  int istart = 0;
  int iend = 0;
  double range_min = -16000;
  double range_max = 16000.;
  string infile;
  string outfile;
  string outppfname;
  string intoi = "boloMuV_27";
  bool fg_f_filt = false;
  bool fg_killfreq = false;
  int bf_killfreq = 1;
  int nharm_killfreq = 1;
  double sigf_killfreq = 1.;

  if (narg < 4) Usage(true);
  int ko=1;
  // decoding arguments 
  for(int ia=1; ia<narg; ia++) {
    if (strcmp(arg[ia],"-start") == 0) {
      if (ia == narg-1) Usage(true);  // -start est suivi d'un argument 
      istart = atoi(arg[ia+1]); ia++;
      fgsetstart = true;
    }    
    else if (strcmp(arg[ia],"-end") == 0) {
      if (ia == narg-1) Usage(true);  
      iend = atoi(arg[ia+1]); ia++;
    }    
    else if (strcmp(arg[ia],"-wtoi") == 0) {
      if (ia == narg-1) Usage(true);  
      wtoi = atoi(arg[ia+1]); ia++;
    }    
    else if (strcmp(arg[ia],"-wdegli") == 0) {
      if (ia == narg-1) Usage(true);  
      wdegli = atoi(arg[ia+1]); ia++;
    }    
    else if (strcmp(arg[ia],"-wfft") == 0) {
      if (ia == narg-1) Usage(true);  
      wfft = atoi(arg[ia+1]); ia++;
      fg_f_filt = true;
    }    
    else if (strcmp(arg[ia],"-keepfft") == 0) {
      if (ia == narg-1) Usage(true);  
      keepfft = atoi(arg[ia+1]); ia++;
    }    
    else if (strcmp(arg[ia],"-killfreq") == 0) {
      if (ia == narg-1) Usage(true);
      sscanf(arg[ia+1],"%d,%d,%lf",&bf_killfreq, &nharm_killfreq, &sigf_killfreq);
      fg_killfreq = true;
      ia++;
    }    
    else if (strcmp(arg[ia],"-range") == 0) {
      if (ia == narg-1) Usage(true);
      sscanf(arg[ia+1],"%lf,%lf",&range_min, &range_max);
      ia++;
    }    
    else if (strcmp(arg[ia],"-intoi") == 0) {
      if (ia == narg-1) Usage(true);  
      intoi = arg[ia+1]; ia++;
    }    
    else if (strcmp(arg[ia],"-dbg") == 0)  fgdbg = true;

    else { ko = ia; break; }  // Debut des noms
  }

  if (iend < istart) iend = istart+wtoi*(nmax+5);
  if ((narg-ko) < 3)  Usage(true); 
  infile = arg[ko];
  outfile = arg[ko+1];
  outppfname = arg[ko+2];

  cout << " Initializing SOPHYA ... " << endl;
  SophyaInit();
  InitTim();

  cout << ">>>> simtst: Infile= " << infile << " outFile=" 
       << outfile << endl; 
  cout << ">>>> Window Size WTOI= " << wtoi << " WDEGLI= " << wdegli
       << "  iStart= " << istart << " iEnd= " << iend << endl;
  cout << ">>>> InTOIName= " << intoi << endl;

  try {
    TOIManager* mgr = TOIManager::getManager();
  
    //  mgr->setRequestedSample(11680920,11710584);
    //  mgr->setRequestedSample(104121000, 104946120);
    if (fgsetstart) 
      mgr->setRequestedSample(istart, iend);
  
    //    FITSTOIReader r("/data/Archeops/bolo11.fits); 
    FITSTOIReader r(infile); 
    cout << "reader created" << endl;
    //    FITSTOIWriter w("/data/Archeops/rz.fits");
    FITSTOIWriter w(outfile);
    cout << "fits writer created" << endl;


    int w1 = wtoi;
    int w2 = (fg_f_filt) ? wfft+w1 : w1; 

    //    char * colname[5] = {"MJD", "UTC","boloMuV_11","magnFlux","pivot"};
    //    char * toiname[5] = {"MJD", "UTC","bolo11","magneto","pivot"};
    TOISeqBuffered * toiin = new TOISeqBuffered("f2in", w1);
    if (fgdbg) toiin->setDebugLevel(1);
    TOISeqBuffered * toidegli = new TOISeqBuffered("degli", w1);
    if (fgdbg) toidegli->setDebugLevel(1);
    TOISeqBuffered * toimean = new TOISeqBuffered("mean", w1);
    if (fgdbg) toimean->setDebugLevel(1);
    TOISeqBuffered * toisig = new TOISeqBuffered("sigma", w2);
    if (fgdbg) toisig->setDebugLevel(1);
    TOISeqBuffered * toiincopie = new TOISeqBuffered("incopie", w2);
    if (fgdbg) toiincopie->setDebugLevel(1);
    
  

    // Connecting TOI to FITSTOIReader Processor
    //    for(kk=0; kk<5; kk++) {
    //      r.addOutput(colname[kk], toitab[kk]);
    //    }

    //    int kk = 2;
    r.addOutput(intoi, toiin);
    //  toi->dbg=true;
    //  r.addOutput("boloMuV_11", toi);
    cout << " connecting in/out to RzTOIProcessor ... " << endl;

    //    TOIProcessor * filt = NULL;

    cout << " Creating SimpleDeglitcher() " << endl;
    SimpleDeglitcher degl(wdegli);
    degl.SetDetectionParam(3.,1.5, 4, 2, 10);
    cout << " Setting Range for deglitcher: " << range_min 
	 << " - " << range_max << endl;

    degl.SetRange(range_min, range_max);
    degl.addInput("in", toiin);
    degl.addOutput("out", toidegli);
    degl.addOutput("mean", toimean);
    degl.addOutput("sigma", toisig);
    degl.addOutput("incopie", toiincopie);
    
    cout << " Creating a FanOut SimpleFanOut Object " << endl;
    SimpleFanOut fanout(2,2);
    TOISeqBuffered * toidegli0 = new TOISeqBuffered("degli0", w1);
    if (fgdbg) toidegli0->setDebugLevel(1);
    TOISeqBuffered * toidegli1 = new TOISeqBuffered("degli1", w2);

    TOISeqBuffered * toimean0 = new TOISeqBuffered("mean0", w1);
    if (fgdbg) toimean0->setDebugLevel(1);
    TOISeqBuffered * toimean1 = new TOISeqBuffered("mean1", w2);
    if (fgdbg) toimean1->setDebugLevel(1);
    
    fanout.addInput("in0", toidegli);
    fanout.addOutput("out0_0", toidegli0);
    fanout.addOutput("out0_1", toidegli1);
    fanout.addInput("in1", toimean);
    fanout.addOutput("out1_0", toimean0);
    fanout.addOutput("out1_1", toimean1);

    cout << " Creating an Adder SimpleAdder Object " << endl;
    SimpleAdder adder(2);
    adder.addInput("in0", toidegli0);
    adder.addInput("in1", toimean0);
    adder.SetGain(0, 1.);
    adder.SetGain(1, -1.);
    TOISeqBuffered * toideglioff = new TOISeqBuffered("deglioff", w1);
    if (fgdbg) toideglioff->setDebugLevel(1);
    adder.addOutput("out", toideglioff);

    cout << " Creating a GaussianFilter SimpleFilter Object " << endl;
    double G_sigma = 2.0;
    double G_a = 1./(G_sigma*sqrt(M_PI*2.));
    SimpleFilter filt(16, SimpleFilter::GaussFilter, G_a, G_sigma);

    filt.addInput("in", toideglioff);
    TOISeqBuffered * toiout = new TOISeqBuffered("out", w1);
    if (fgdbg) toiout->setDebugLevel(1);
    TOISeqBuffered * toideglioffcopie = new TOISeqBuffered("deglioffcopie", w2);
    if (fgdbg) toideglioffcopie->setDebugLevel(1);
    filt.addOutput("out", toiout);
    filt.addOutput("incopie", toideglioffcopie);

    Vector fcoef(wfft/2+1);
    //    fcoef = RegularSequence(1., -2./wfft);
    fcoef = 1.;
    for(int kfk=0; kfk<nharm_killfreq; kfk++) {
      double cfreq = bf_killfreq*(kfk+1);
      double xfreq = 0.;
      for(int kfj=cfreq-3.*sigf_killfreq; kfj<= cfreq+3.*sigf_killfreq; kfj++) {
	if ( (kfj < 0) || (kfj >= fcoef.Size() ) )  continue;
	xfreq = (cfreq-kfj)/sigf_killfreq;
	fcoef(kfj) -= exp(-xfreq*xfreq);
      }
    }
    cout << " Creating Fourier Filter ... " << endl;
    SimpleFourierFilter sfft(fcoef);
    sfft.KeepSpectra(outppfname, keepfft);
    sfft.ComputeMeanSpectra(true);
    TOISeqBuffered * toifft = NULL;
    TOISeqBuffered * toifiltcopie = NULL;

    if (fg_f_filt) {
      cout << " Connecting Fourier Filter ... " << endl;
      toifft = new TOISeqBuffered("fftout", w1);
      toifiltcopie = new TOISeqBuffered("filtcopie", w1);
      sfft.addInput("in",toiout);
      sfft.addOutput("out", toifft);
      sfft.addOutput("incopie", toifiltcopie);
    }

    cout << " Connecting to output (FitsWriter) " << endl;
    
    w.setOutFlags(true);
    w.addInput("in", toiincopie);
    if (fg_f_filt) {
      w.addInput("filtout", toifiltcopie);
      w.addInput("fftout", toifft);
    } 
    else   w.addInput("filtout", toiout);
    w.addInput("degli", toidegli1);
    w.addInput("deglioff", toideglioffcopie);
    w.addInput("mean", toimean1);
    w.addInput("sigma", toisig);

    cout << " ------ FITSReaderTOI::PrintStatus() : ----- " << endl;
    r.PrintStatus(cout);  
    cout << " ------ FanOut::PrintStatus() : ----- " << endl;
    fanout.PrintStatus(cout);  
    cout << " ------ Adder::PrintStatus() : ----- " << endl;
    adder.PrintStatus(cout);  
    cout << " ------ Filter::PrintStatus() : ----- " << endl;
    filt.PrintStatus(cout);  
    cout << "----- FITSWriterTOI::PrintStatus() : ----- " << endl;
    w.PrintStatus(cout);  

    PrtTim("starting threads");
    r.start();
    degl.start();
    fanout.start();
    adder.start();
    filt.start();
    if (fg_f_filt) sfft.start();
    w.start();

    /*
    for(int jj=0; jj<3; jj++) {
      cout << *toiin; 
      cout << *toimean; 
      cout << *toimean1; 
      cout << *toiout; 
      sleep(1);
    }
    
    */

    mgr->joinAll();
    PrtTim("End threads");

    //    cout << " ------ FITSReaderTOI::PrintStatus() : ----- " << endl;
    //    r.PrintStatus(cout);  
    //    cout << "----- FITSWriterTOI::PrintStatus() : ----- " << endl;
    //    w.PrintStatus(cout);  

    cout << " ------ toiin, toidegli and toiout Status information ------- " << endl;
    cout << *toiin; 
    cout << *toidegli; 
    cout << *toiout;

    cout << degl;
    cout << filt;
    cout << adder;
    if (fg_f_filt) cout << sfft ; 

  }
  catch (PThrowable & exc) {
    cerr << "\nrztsttoi: Catched Exception \n" << (string)typeid(exc).name() 
	 << " - Msg= " << exc.Msg() << endl;
  }
  catch (const std::exception & sex) {
    cerr << "\nrztsttoi: Catched std::exception \n" 
	 << (string)typeid(sex).name() << endl; 
  }
  catch (...) {
    cerr << "\nrztsttoi: some other exception was caught ! " << endl;
  }

  return(0);
}
