/*   Test de processeurs ds simtoipr.cc   - Reza Avril 2001

----------------   Exemple d'appel  ---------------------
csh> sfftc -start 104385384 -end 104399964 
            -intoi boloMuV_27 -wtoi 8192 -wfft 4096 inputbolo.fits sfftc.fits sfftc.ppf
*/



#include "machdefs.h"
#include <math.h>
#include "array.h"
#include <unistd.h>
#include <stdexcept>
#include "toi.h"
#include "toiprocessor.h"
#include "fitstoirdr.h"
#include "fitstoiwtr.h"
#include "toimanager.h"
#include "simtoipr.h"
#include "toiseqbuff.h"
#include "timing.h"
#include "sambainit.h"

void Usage(bool fgerr)
{
  cout << endl;
  if (fgerr) {
    cout << " sfftc : Argument Error ! sfftc -h for usage " << endl; 
    exit(1);
  }
  else {
    cout << "\n Usage : sfftc [-dbg] [-start snb] [-end sne] \n" 
	 << "         [-wtoi sz] [-wfft sz] [-keepfft n] \n"
	 << "         inFitsName outFitsName  outPPFName \n" 
	 << "   -dbg : sets TOISeqBuffered debug level to 1 \n"
	 << "   -start snb : sets the start sample num \n"
	 << "   -end sne : sets the end sample num \n"
	 << "   -intoi toiName : select input TOI name (def boloMuV_27)\n"
	 << "   -wtoi sz : sets TOISeqBuff buffer size (def= 8192)\n"
	 << "   -wfft sz : sets Fourier filter width \n"
	 << "   -keepfft n : Keeps n spectra  \n" 
	 << endl;
    exit(0);
  }
}

int main(int narg, char** arg) {

  if ((narg > 1) && (strcmp(arg[1],"-h") == 0) ) Usage(false);

  cout << "sfftc starting - Decoding arguments " << " narg=" << narg << endl;

  bool fgdbg = false;
  bool fgsetstart = false;
  int wtoi = 8192;
  int wfft = 4096;
  int keepfft = 0;
  int nmax = 10;
  int istart = 0;
  int iend = 0;
  string infile;
  string outfile;
  string outppfname;
  string intoi = "boloMuV_27";

  if (narg < 4) Usage(true);
  int ko=1;
  // decoding arguments 
  for(int ia=1; ia<narg; ia++) {
    if (strcmp(arg[ia],"-start") == 0) {
      if (ia == narg-1) Usage(true);  // -start est suivi d'un argument 
      istart = atoi(arg[ia+1]); ia++;
      fgsetstart = true;
    }    
    else if (strcmp(arg[ia],"-end") == 0) {
      if (ia == narg-1) Usage(true);  
      iend = atoi(arg[ia+1]); ia++;
    }    
    else if (strcmp(arg[ia],"-wtoi") == 0) {
      if (ia == narg-1) Usage(true);  
      wtoi = atoi(arg[ia+1]); ia++;
    }    
    else if (strcmp(arg[ia],"-wfft") == 0) {
      if (ia == narg-1) Usage(true);  
      wfft = atoi(arg[ia+1]); ia++;
    }    
    else if (strcmp(arg[ia],"-keepfft") == 0) {
      if (ia == narg-1) Usage(true);  
      keepfft = atoi(arg[ia+1]); ia++;
    }    
    else if (strcmp(arg[ia],"-intoi") == 0) {
      if (ia == narg-1) Usage(true);  
      intoi = arg[ia+1]; ia++;
    }    
    else if (strcmp(arg[ia],"-dbg") == 0)  fgdbg = true;

    else { ko = ia; break; }  // Debut des noms
  }

  if (iend < istart) iend = istart+wtoi*(nmax+5);
  if ((narg-ko) < 3)  Usage(true); 
  infile = arg[ko];
  outfile = arg[ko+1];
  outppfname = arg[ko+2];

  cout << " Initializing SOPHYA ... " << endl;
  SophyaInit();
  InitTim();

  cout << ">>>> sfftc: Infile= " << infile << " outFile=" 
       << outfile << endl; 
  cout << ">>>> Window Size WTOI= " << wtoi << " WFFT= " << wfft
       << "  iStart= " << istart << " iEnd= " << iend << endl;
  cout << ">>>> InTOIName= " << intoi << endl;

  try {
    TOIManager* mgr = TOIManager::getManager();
  
    //  mgr->setRequestedSample(11680920,11710584);
    //  mgr->setRequestedSample(104121000, 104946120);
    if (fgsetstart) 
      mgr->setRequestedSample(istart, iend);
  
    //    FITSTOIReader r("/data/Archeops/bolo11.fits); 
    FITSTOIReader r(infile); 
    cout << "reader created" << endl;
    //    FITSTOIWriter w("/data/Archeops/rz.fits");
    FITSTOIWriter w(outfile);
    cout << "fits writer created" << endl;


    int w1 = wtoi;
    TOISeqBuffered * toiin = new TOISeqBuffered("f2in", w1);
    if (fgdbg) toiin->setDebugLevel(1);
    TOISeqBuffered * toiout = new TOISeqBuffered("out", w1);
    if (fgdbg) toiout->setDebugLevel(1);
    TOISeqBuffered * toiincopie = new TOISeqBuffered("incopie", w1);
    if (fgdbg) toiincopie->setDebugLevel(1);
    
  
    cout << " Connecting to FitsReader ... " << endl;
    r.addOutput(intoi, toiin);

    Vector fcoef(wfft/2);
    fcoef = RegularSequence(1., -2./wfft);
    cout << " Creating Fourier Filter ... " << endl;
    SimpleFourierFilter sfft(fcoef);
    sfft.KeepSpectra(outppfname, keepfft);
    cout << " Connecting Fourier Filter ... " << endl;
    sfft.addInput("in",toiin);
    sfft.addOutput("out", toiout);
    sfft.addOutput("incopie", toiincopie);

    cout << " Connecting to output (FitsWriter) " << endl;
    
    //    w.setOutFlags(true);
    w.addInput("in", toiincopie);
    w.addInput("out", toiout);


    cout << " ------ FITSReaderTOI::PrintStatus() : ----- " << endl;
    r.PrintStatus(cout);  
    cout << " ------ SimpleFourierFilter::PrintStatus() : ----- " << endl;
    sfft.PrintStatus(cout);  
    cout << "----- FITSWriterTOI::PrintStatus() : ----- " << endl;
    w.PrintStatus(cout);  

    PrtTim("starting threads");
    r.start();
    sfft.start();
    w.start();

    /*   
    for(int jj=0; jj<3; jj++) {
      cout << *toiin; 
      cout << *toiout; 
      cout << *toiincopie; 
      sleep(1);
    }
    */
    
    

    mgr->joinAll();
    PrtTim("End threads");

    //    cout << " ------ FITSReaderTOI::PrintStatus() : ----- " << endl;
    //    r.PrintStatus(cout);  
    //    cout << "----- FITSWriterTOI::PrintStatus() : ----- " << endl;
    //    w.PrintStatus(cout);  

    cout << " ------ toiin, toiout and toiincopie Status information ------- " << endl;
    cout << *toiin; 
    cout << *toiout;
    cout << *toiincopie; 
    
    cout << sfft ; 

  }
  catch (PThrowable & exc) {
    cerr << "\n sfftc: Catched Exception \n" << (string)typeid(exc).name() 
	 << " - Msg= " << exc.Msg() << endl;
  }
  catch (const std::exception & sex) {
    cerr << "\n sfftc: Catched std::exception \n" 
	 << (string)typeid(sex).name() << endl; 
  }
  catch (...) {
    cerr << "\n sfftc: some other exception was caught ! " << endl;
  }

  return(0);
}
