#include "toimanager.h"
#include "nooppr.h"
// ----------------------------------------------------------------------
//   Classe SimpleFourierFilter : Filtre simple ds le domaine de Fourier
// ----------------------------------------------------------------------

NoOpProcessor::NoOpProcessor(int wsz)
{
  wsize = wsz;
  totnscount = 0;
}



void NoOpProcessor::PrintStatus(ostream & os)
{
  os << "\n ------------------------------------------------------ \n" 
     << " NoOpProcessor::PrintStatus() - WindowSize=" 
     << WSize() << endl; 
  TOIProcessor::PrintStatus(os);
  os << " ------------------------------------------------------ " << endl;
}

void NoOpProcessor::init() {
  cout << "NoOpProcessor::init" << endl;
  declareInput("in");
  declareOutput("out");
  declareOutput("incopie");
  name = "NoOpProcessor";
  //  upExtra = 1;
}


void NoOpProcessor::run() {
  //  TOIManager* mgr = TOIManager::getManager();
  int snb = getMinIn();
  int sne = getMaxIn();

  bool fgout = checkOutputTOIIndex(0);
  bool fgincopie = checkOutputTOIIndex(1);

  if (!checkInputTOIIndex(0)) {
    cerr << " NoOpProcessor::run() - Input TOI (in) not connected! "
	 << endl;
    throw ParmError("NoOpProcessor::run() Input TOI (in) not connected!");
  }


  cout << " NoOpProcessor::run() SNRange=" << snb << " - " << sne << endl; 
  
  double * vin = NULL;
  double * vout = NULL;
  int_8 * vfg = NULL;
  try {
    // Le debut
    int k,i,klast;
    int nks = 0;
    klast = snb-1;
    int totnbblock = 0;
    
    if (wsize > 1) {
      vin = new double[wsize];
      vout = new double[wsize];
      vfg = new int_8[wsize];
    
      // Boucle sur les sampleNum
      // 1er partie, on traite par paquets de wsize
      for(k=snb;k<=sne-wsize+1;k+=wsize) {
	for(i=0; i<wsize; i++) 
	  getData(0, k+i, vin[i], vfg[i]);
	totnbblock++;
	for(i=0; i<wsize; i++) {
	  if (fgout) 
	    putData(0,k+i,vout[i],vfg[i]);
	  if (fgincopie)  
	    putData(1, k+i, vin[i], vfg[i]);
	}
      }
      klast+=wsize;
      totnscount+=wsize;
    }

    // 2eme partie, on traite la fin du bloc d'echantillons si necessaire
    double inval;
    int_8 inflg;
    if (klast < sne) 
      for(k=klast+1; k<=sne; k++) {
	getData(0, k, inval, inflg);
	if (fgout) putData(0, k, inval, inflg);
	if (fgincopie) 
	  putData(1, k, inval, inflg);
	totnscount++;
      }

    totnbblock++;

    cout << " NoOpProcessor::run() - End of processing " 
	 << " NbFFTBlocks= " << totnbblock << endl;
  }  // Bloc try 

  catch (PException & exc) {
    cerr << "NoOpProcessor: Catched Exception " << (string)typeid(exc).name()
         << "\n .... Msg= " << exc.Msg() << endl;
  }

  if (vin) delete[] vin; 
  if (vout) delete[] vout;
  if (vfg) delete[] vfg;  

}
