/*   mesure de performance de l'architecture

----------------   Exemple d'appel  ---------------------
csh> mesovh -start 104385384 -end 104399964 
            -intoi boloMuV_27 -wtoi 8192 -wnoop 4096 inputbolo.fits 
*/



#include "machdefs.h"
#include <math.h>
#include "array.h"
#include <unistd.h>
#include <stdexcept>
#include "toi.h"
#include "toiprocessor.h"
#include "fitstoirdr.h"
#include "fitstoiwtr.h"
#include "toimanager.h"
#include "nooppr.h"
#include "toiseqbuff.h"
#include "timing.h"
// #include "sambainit.h"

void Usage(bool fgerr)
{
  cout << endl;
  if (fgerr) {
    cout << " mesovh : Argument Error ! mesovh -h for usage " << endl; 
    exit(1);
  }
  else {
    cout << "\n Usage : mesovh [-dbg] [-start snb] [-end sne] \n" 
	 << "         [-intoi name] [-wtoi sz] [-wnoop sz] [-bipro] \n"
         << "         [-intoi2 name] inFitsName \n"
	 << "   -dbg : sets TOISeqBuffered debug level to 1 \n"
	 << "   -start snb : sets the start sample num \n"
	 << "   -end sne : sets the end sample num \n"
	 << "   -intoi toiName : select input TOI name (def boloMuV_27)\n"
	 << "   -wtoi sz : sets TOISeqBuff buffer size (def= 8192)\n"
	 << "   -wnoop sz : sets NoOpProcessor window size \n"
	 << "   -bipro : chain 2 processors \n"
	 << "   -intoi2 toiName : chaine 2 procs with toi2->in2\n"
	 << endl;
    exit(0);
  }
}

int main(int narg, char** arg) {

  if ((narg > 1) && (strcmp(arg[1],"-h") == 0) ) Usage(false);

  cout << "mesovh starting - Decoding arguments " << " narg=" << narg << endl;

  bool fgdbg = false;
  bool fgbipro = false;
  bool fgsetstart = false;
  int wtoi = 8192;
  int wnoop = 0;
  int keepfft = 0;
  int nmax = 10;
  int istart = 0;
  int iend = 0;
  string infile;
  string outfile;
  string outppfname;
  string intoi = "boloMuV_27";
  bool fgtoi2 = false;
  string intoi2;

  if (narg < 4) Usage(true);
  int ko=1;
  // decoding arguments 
  for(int ia=1; ia<narg; ia++) {
    if (strcmp(arg[ia],"-start") == 0) {
      if (ia == narg-1) Usage(true);  // -start est suivi d'un argument 
      istart = atoi(arg[ia+1]); ia++;
      fgsetstart = true;
    }    
    else if (strcmp(arg[ia],"-end") == 0) {
      if (ia == narg-1) Usage(true);  
      iend = atoi(arg[ia+1]); ia++;
    }    
    else if (strcmp(arg[ia],"-wtoi") == 0) {
      if (ia == narg-1) Usage(true);  
      wtoi = atoi(arg[ia+1]); ia++;
    }    
    else if (strcmp(arg[ia],"-wnoop") == 0) {
      if (ia == narg-1) Usage(true);  
      wnoop = atoi(arg[ia+1]); ia++;
    }    
    else if (strcmp(arg[ia],"-intoi") == 0) {
      if (ia == narg-1) Usage(true);  
      intoi = arg[ia+1]; ia++;
    }    
    else if (strcmp(arg[ia],"-intoi2") == 0) {
      if (ia == narg-1) Usage(true);
      fgbipro = fgtoi2 = true;
      intoi2 = arg[ia+1]; ia++;
    }    
    else if (strcmp(arg[ia],"-bipro") == 0)  fgbipro = true;
    else if (strcmp(arg[ia],"-dbg") == 0)  fgdbg = true;

    else { ko = ia; break; }  // Debut des noms
  }

  if (iend < istart) iend = istart+wtoi*(nmax+5);
  if ((narg-ko) < 1)  Usage(true); 
  infile = arg[ko];
  //  outfile = arg[ko+1];
  //  outppfname = arg[ko+2];

  //  cout << " Initializing SOPHYA ... " << endl;
  //  SophyaInit();
  InitTim();

  cout << ">>>> mesovh: Infile= " << infile << " outFile=" 
       << outfile << endl; 
  cout << ">>>> Window Size WTOI= " << wtoi << " WNOOP= " << wnoop
       << "  iStart= " << istart << " iEnd= " << iend << endl;
  cout << ">>>> InTOIName= " << intoi << endl;

  try {
    TOIManager* mgr = TOIManager::getManager();
  
    //  mgr->setRequestedSample(11680920,11710584);
    //  mgr->setRequestedSample(104121000, 104946120);
    if (fgsetstart) 
      mgr->setRequestedSample(istart, iend);
  
    //    FITSTOIReader r("/data/Archeops/bolo11.fits); 
    FITSTOIReader r(infile); 
    cout << "reader created" << endl;
    //    FITSTOIWriter w("/data/Archeops/rz.fits");
    //    FITSTOIWriter w(outfile);
    //    cout << "fits writer created" << endl;


    int w1 = wtoi;
    TOISeqBuffered * toiin = new TOISeqBuffered("f2in", w1);
    if (fgdbg) toiin->setDebugLevel(1);
    //    TOISeqBuffered * toiout = new TOISeqBuffered("out", w1);
    //    if (fgdbg) toiout->setDebugLevel(1);
    //    TOISeqBuffered * toiincopie = new TOISeqBuffered("incopie", w1);
    //    if (fgdbg) toiincopie->setDebugLevel(1);
    
  
    cout << " Connecting to FitsReader ... " << endl;
    r.addOutput(intoi, toiin);

    TOISeqBuffered * toi2 = NULL;    
    if (fgtoi2) {
      int w2 = (wnoop > 0) ? w1+wnoop : w1;
      toi2 = new TOISeqBuffered("toi2", w2);
      r.addOutput(intoi2, toi2);
    }

    NoOpProcessor noop(wnoop);
    NoOpProcessor noop2(wnoop);
    cout << " Connecting NoOpProcessor ... " << endl;
    noop.addInput("in",toiin);
    
    TOISeqBuffered * toi3 = NULL;
    if (fgbipro) {
      toi3 = new TOISeqBuffered("toi3", w1);
      noop.addOutput("out", toi3);
      noop2.addInput("in",toi3);
      if (fgtoi2) {
	noop2.addInput("in2",toi2);
      }
    }

    cout << noop;
    if (fgbipro) cout << noop2;
    PrtTim("starting threads");
    r.start();
    noop.start();
    if (fgbipro)  noop2.start();
    /*   
    for(int jj=0; jj<3; jj++) {
      cout << *toiin; 
      cout << *toiout; 
      cout << *toiincopie; 
      sleep(1);
    }
    */
    
    

    mgr->joinAll();
    PrtTim("End threads");

    //    cout << " ------ FITSReaderTOI::PrintStatus() : ----- " << endl;
    //    r.PrintStatus(cout);  
    //    cout << "----- FITSWriterTOI::PrintStatus() : ----- " << endl;
    //    w.PrintStatus(cout);  

    cout << " ------ toiin, toi2 and toi3 Status information ------- " << endl;
    cout << *toiin; 
    if (toi2) cout << *toi2; 
    if (toi3) cout << *toi3; 
    cout << noop ; 
    if (fgbipro) cout << noop2 ; 
  }
  catch (PThrowable & exc) {
    cerr << "\n mesovh: Catched Exception \n" << (string)typeid(exc).name() 
	 << " - Msg= " << exc.Msg() << endl;
  }
  catch (const std::exception & sex) {
    cerr << "\n mesovh: Catched std::exception \n" 
	 << (string)typeid(sex).name() << endl; 
  }
  catch (...) {
    cerr << "\n mesovh: some other exception was caught ! " << endl;
  }

  return(0);
}
