// This may look like C code, but it is really -*- C++ -*-

#ifndef GENWPROC_H
#define GENWPROC_H

#include "toiprocessor.h"
#include "tvector.h"

#include <vector>


class GenWindowTOIProcessor : public TOIProcessor {
public:
  GenWindowTOIProcessor(int nbinput,int nboutput,int wsz, int wstep=1, int wsztot=-1);
  ~GenWindowTOIProcessor();

  inline int_8 GetWSize() const { return WSize; }
  inline int_8 GetWStep() const { return WStep; }
  inline int_8 ProcessedSampleCount() const { return TotNsCount; }

  inline int_8 GetStartSample()  {return StartSample;}
  inline int_8 GetCenterSample() {return StartSample + WSize/2;}
  TVector<r_8> GetWData(int numtoi=0);
  TVector<int_8> GetWFlag(int numtoi=0);
  void PutWData(int numtoi,int_8 numsample,TVector<r_8>& data,TVector<int_8>& flag);
  void PutWData(int numtoi,int_8 numsample,r_8 data,int_8 flag);
  inline void PutWData(int_8 numsample,TVector<r_8>& data,TVector<int_8>& flag)
                      {PutWData(0,numsample,data,flag);}
  inline void PutWData(int_8 numsample,r_8 data,int_8 flag)
                      {PutWData(0,numsample,data,flag);}

  virtual void PrintStatus(ostream & os);

  virtual void UserInit();
  virtual void UserProc();
  virtual void UserEnd();

  virtual void	init();  
  virtual void	run();

protected:
  void Remplissage(int_8 ks);
  inline int_8 StartSnIndex()
         {if(CurSnInd<0) return -1; else return CurSnInd-WSize;}
  inline int_8 CenterSnIndex()
         {if(CurSnInd<0) return -1; else return CurSnInd-(WSize+1)/2;}

  int NbInput,NbOutput;
  int_8 WSizeTot,WSize,WStep;
  int_8 SNdeb,SNend;
  int_8 StartSample,CurSnInd;
  int_8 TotNsCount;
  vector< TVector<r_8>   > WDataIn;
  vector< TVector<int_8> > WFlagIn;
  vector< TVector<r_8>   > WDataOut;
  vector< TVector<int_8> > WFlagOut;
  vector< bool > WInFlg;
  vector< bool > WOutFlg;
  vector< bool > WPutOutFlg;
  vector< int_8 > OutSample;
};

#endif
