// This may look like C code, but it is really -*- C++ -*-

#ifndef GENWPROC_H
#define GENWPROC_H

#include "toiprocessor.h"
#include "tvector.h"

#include <vector>


class GenWindowTOIProcessor : public TOIProcessor {
public:
  GenWindowTOIProcessor(int nbinput,int nboutput,int wsz, int wstep=1, int wsztot=-1);
  virtual ~GenWindowTOIProcessor();

  inline int_8 GetWSize() const { return WSize; }
  inline int_8 GetWStep() const { return WStep; }
  inline int_8 ProcessedSampleCount() const { return TotNsCount; }

  inline int_8 GetStartSample()  {return StartSample;}
  inline int_8 GetCenterSample() {return StartSample + WSize/2;}
  inline int_8 StartSampleNum() { return SNdeb; }
  inline int_8 EndSampleNum() { return SNend; }

  inline void SetDefaultValue(r_8 r8dval=0., int_8 i8dval=0)
                      {R8DefVal = r8dval; I8DefVal = i8dval;}

  TVector<r_8> GetWData(int numtoi=0);
  TVector<int_8> GetWFlag(int numtoi=0);
  r_8 * GetWDataPointer(int numtoi=0);
  int_8 * GetWFlagPointer(int numtoi=0);
  void GetData(int numtoi, int_8 numsample, r_8 & data, int_8 & flag);
  inline void GetData(int_8 numsample, r_8 & data, int_8 & flag)
                      { GetData(0, numsample, data, flag); }

  void PutWData(int numtoi,int_8 numsample,TVector<r_8>& data,TVector<int_8>& flag);
  void PutWData(int numtoi,int_8 numsample,r_8 data,int_8 flag);
  inline void PutWData(int_8 numsample,TVector<r_8>& data,TVector<int_8>& flag)
                      {PutWData(0,numsample,data,flag);}
  inline void PutWData(int_8 numsample,r_8 data,int_8 flag)
                      {PutWData(0,numsample,data,flag);}

  virtual void PrintStatus(ostream & os);

  virtual void UserInit(int_8 kstart);
  virtual void UserProc(int_8 ks);
  virtual void UserEnd(int_8 kend);

  virtual void	init();  
  virtual void	run();

protected:
  void Remplissage(int_8 ks);
  void Ecriture();
  inline int_8 StartWtIndex()
         {if(CurWtIndex<0) return -1; else return CurWtIndex-WSize;}
  inline int_8 CenterWtIndex()
         {if(CurWtIndex<0) return -1; else return CurWtIndex-(WSize+1)/2;}

  int NbInput,NbOutput;
  int_8 WSizeTot,WSize,WStep;
  int_8 SNdeb,SNend;
  int_8 StartSample,CurWtIndex;
  int_8 TotNsCount;
  r_8 R8DefVal;
  int_8 I8DefVal;
  vector< TVector<r_8>   > WDataIn;
  vector< TVector<int_8> > WFlagIn;
  vector< TVector<r_8>   > WDataOut;
  vector< TVector<int_8> > WFlagOut;
  vector< bool > WInFlg;
  vector< bool > WOutFlg;
  vector< bool > WPutOutFlg;
  vector< bool > WPutOutOwnVector;
  vector< int_8 > OutSample;
};

#endif
