#include "array.h"
#include <math.h>
#include "genwproc.h"
#include "toimanager.h"
#include "pexceptions.h"
#include "ctimer.h"


// #define DEBUGGENW 1 

// -------------------------------------------------------------
//   Class GenWindowTOIProcessor : generic processor with window
// -------------------------------------------------------------

////////////////////////////////////////////////////////////////
GenWindowTOIProcessor::GenWindowTOIProcessor(int nbinput,int nboutput
                                   ,int wsz, int wstep, int wsztot)
{
  if(nbinput<1) throw ParmError("GenWindowTOIProcessor::Creator nbinput<1 !");
  if(nboutput<0) nboutput=0;
  if(wsz<2) throw ParmError("GenWindowTOIProcessor::Creator wsz<2 !");
  if(wsz%2==0) wsz++;
  if(wstep<1) wstep=1;
  if(wsztot<wsz) wsztot = 2*wsz;  // CMV prise de decision wsztot / wstep

  NbInput = nbinput;
  NbOutput = nboutput;
  WSize = wsz;
  WStep = wstep;
  WSizeTot = wsztot;

  SNdeb = SNend = StartSample = CurWtIndex = -1;
  TotNsCount = 0;

  SetDefaultValue();

  TVector<r_8> vr8(1);     // CMV+RZ supprimer taille(1) apres correction de 
  TVector<int_8> vi8(1);   // constructeur copie de TArray (taille nulle)
  
  int k;
  for(k=0;k<NbInput;k++) {
    WDataIn.push_back(vr8);
    WFlagIn.push_back(vi8);
    WInFlg.push_back(false);
  }
  if(NbOutput) for(k=0;k<NbOutput;k++) {
    WDataOut.push_back(vr8);
    WFlagOut.push_back(vi8);
    WOutFlg.push_back(false);
    WPutOutFlg.push_back(false);
    WPutOutOwnVector.push_back(false);
    OutSample.push_back(0);
  }
}

GenWindowTOIProcessor::~GenWindowTOIProcessor()
{
}

////////////////////////////////////////////////////////////////
void GenWindowTOIProcessor::PrintStatus(ostream & os)
{
  os<<"\n ------------------------------------------------------ \n" 
    <<" GenWindowTOIProcessor::PrintStatus() - ["
    <<NbInput<<","<<NbOutput<<"] (wtot="<<WSizeTot
    <<" WindowSize="<<GetWSize()
    <<" WStep= "<<GetWStep()<<endl;
  TOIProcessor::PrintStatus(os);
  os<<"ProcessedSampleCount="<<ProcessedSampleCount()<<endl;
  os<<"------------------------------------------------------ "<<endl;
}

////////////////////////////////////////////////////////////////
TVector<r_8> GenWindowTOIProcessor::GetWData(int numtoi)
{
  if(numtoi<0 || numtoi>=NbInput)
    throw RangeCheckError("GenWindowTOIProcessor::GetWData : toi out of range !");
  if(!WInFlg[numtoi])
    throw ParmError("GenWindowTOIProcessor::GetWData : toi not connected!");
  return (WDataIn[numtoi])(Range(StartWtIndex(),0,WSize));
}

TVector<int_8> GenWindowTOIProcessor::GetWFlag(int numtoi)
{
  if(numtoi<0 || numtoi>=NbInput)
    throw RangeCheckError("GenWindowTOIProcessor::GetWFlag : toi out of range !");
  if(!WInFlg[numtoi])
    throw ParmError("GenWindowTOIProcessor::GetWFlag : toi not connected!");
  return (WFlagIn[numtoi])(Range(StartWtIndex(),0,WSize));
}

r_8 * GenWindowTOIProcessor::GetWDataPointer(int numtoi)
{
  if(numtoi<0 || numtoi>=NbInput)
    throw RangeCheckError("GenWindowTOIProcessor::GetWDataPointer : toi out of range !");
  if(!WInFlg[numtoi])
    throw ParmError("GenWindowTOIProcessor::GetWDataPointer : toi not connected!");
  return (WDataIn[numtoi].Data()+StartWtIndex());

}
 
int_8 * GenWindowTOIProcessor::GetWFlagPointer(int numtoi)
{
  if(numtoi<0 || numtoi>=NbInput)
    throw RangeCheckError("GenWindowTOIProcessor::GetWFlagPointer : toi out of range !");
  if(!WInFlg[numtoi])
    throw ParmError("GenWindowTOIProcessor::GetWFlagPointer : toi not connected!");
  return (WFlagIn[numtoi].Data()+StartWtIndex());
}

void GenWindowTOIProcessor::GetData(int numtoi, int_8 numsample, r_8 & data, int_8 & flag)
{
  if(numtoi<0 || numtoi>=NbInput)
    throw RangeCheckError("GenWindowTOIProcessor::GetData : toi out of range !");
  if(!WInFlg[numtoi])
    throw ParmError("GenWindowTOIProcessor::GetData : toi not connected!");
  int_8 k = numsample-GetStartSample();
  if ((k<0) || (k >= GetWSize()))
    throw RangeCheckError("GenWindowTOIProcessor::GetData : numsample out of window!");
  k += StartWtIndex();
  data = (WDataIn[numtoi])(k);
  flag = (WFlagIn[numtoi])(k);
}

////////////////////////////////////////////////////////////////
void GenWindowTOIProcessor::PutWData(int numtoi,int_8 numsample
                                    ,TVector<r_8>& data,TVector<int_8>& flag)
{
  if(numtoi<0 || numtoi>=NbOutput)
    throw RangeCheckError("GenWindowTOIProcessor::PutWFlag : toi out of range !");
  if(!WOutFlg[numtoi])
    throw ParmError("GenWindowTOIProcessor::PutWFlag : toi not connected!");
  if(data.Size()!=flag.Size())
    throw ParmError("GenWindowTOIProcessor::PutWFlag : data.Size()!=flag.Size()!");
  if(data.Size() == 0)
    throw ParmError("GenWindowTOIProcessor::PutWFlag : data.Size()==0 !");
  WDataOut[numtoi].Share(data);
  WFlagOut[numtoi].Share(flag);
  OutSample[numtoi] = numsample;
  WPutOutFlg[numtoi] = true;
  WPutOutOwnVector[numtoi] = false;
}

void GenWindowTOIProcessor::PutWData(int numtoi,int_8 numsample
                                    ,r_8 data,int_8 flag)
{
  if(numtoi<0 || numtoi>=NbOutput)
    throw RangeCheckError("GenWindowTOIProcessor::PutWFlag : toi out of range !");
  if(!WOutFlg[numtoi])
    throw ParmError("GenWindowTOIProcessor::PutWFlag : toi not connected!");
  if (!WPutOutOwnVector[numtoi]) {
    WDataOut[numtoi].Realloc(1,BaseArray::SameVectorType,true);
    WFlagOut[numtoi].Realloc(1,BaseArray::SameVectorType,true);
    WPutOutOwnVector[numtoi] = true;
  }
  (WDataOut[numtoi])(0) = data;
  (WFlagOut[numtoi])(0) = flag;
  OutSample[numtoi] = numsample;
  WPutOutFlg[numtoi] = true;
}

////////////////////////////////////////////////////////////////
void GenWindowTOIProcessor::UserInit(int_8 kstart)
{
  cout<<"GenWindowTOIProcessor::UserInit() Default implementation does nothing"<<endl;
}

void GenWindowTOIProcessor::UserProc(int_8 ks)
{
  cout<<"GenWindowTOIProcessor:UserProc() Default implementation does nothing"<<endl;
}

void GenWindowTOIProcessor::UserEnd(int_8 kend)
{
  cout<<"GenWindowTOIProcessor::UserEnd() Default implementation does nothing"<<endl;
}

////////////////////////////////////////////////////////////////
void GenWindowTOIProcessor::init()
{
  cout << "GenWindowTOIProcessor::init" << endl;
  char buff[64];
  int k;
  for(k=0; k<NbInput; k++) {
    sprintf(buff,"in%d", k);
    declareInput(buff);
  }
  for(k=0; k<NbOutput; k++) {
    sprintf(buff,"out%d",k);
    declareOutput(buff);
  }
  name = "GenWindowTOIProcessor";
  // upExtra = 1; $CHECK a quoi ca sert EA?
}

void GenWindowTOIProcessor::run()
{
  //  TOIManager* mgr = TOIManager::getManager();
  SNdeb = getMinIn();
  SNend = getMaxIn();
  if(SNend-SNdeb<WSize)
    throw ParmError("GenWindowTOIProcessor::run : sne-snb<WSize !");

  // Allocation des tailles pour les vecteurs
  int kc, nc=0;
  for(kc=0;kc<NbInput;kc++) {
    if( !(WInFlg[kc]=checkInputTOIIndex(kc)) ) continue;
     WDataIn[kc].ReSize(WSizeTot);
     WFlagIn[kc].ReSize(WSizeTot);
     nc++;
  }
  if(nc==0) {
    cerr<<" GenWindowTOIProcessor::run() - No input TOI connected!"<<endl;
    throw ParmError("GenWindowTOIProcessor::run() No input TOI connected!");
  }
  for(kc=0;kc<NbOutput;kc++) WOutFlg[kc] = checkOutputTOIIndex(kc);

  // Lecture des samples et remplissage des vecteurs
  cout<<"GenWindowTOIProcessor::run() SNRange="<<SNdeb<<" - "<<SNend<<endl; 
  try {
    Timer tm("GenWindowTOIProcessor::run()");
    for(int_8 ks=SNdeb;ks<=SNend;ks++) {  // CMV gerer le += step
      Remplissage(ks);
      if (ks == SNdeb) {
	UserInit(ks);
	Ecriture();
      }
      if ((ks-SNdeb)%WStep == 0) {
	UserProc(ks);
	// Il faut traiter les ecritures en sortie 
	Ecriture();
      }
      TotNsCount++;
    }
    UserEnd(SNend);
    Ecriture();
    cout << " GenWindowTOIProcessor::run() - End of processing " << endl;

  } catch(PException & exc) {
    cerr<<"GenWindowTOIProcessor::run Catched Exception "<<(string)typeid(exc).name()
        <<"\n .... Msg= "<<exc.Msg()<<endl;
  }
}

////////////////////////////////////////////////////////////////
void GenWindowTOIProcessor::Remplissage(int_8 ks)
// INPUT:
//   ks : numero du sample CENTRAL
//      samples :   sn-ws/2        sn          sn+ws/2
//      fenetre :   0              ws/2+1      ws-1
{
#ifdef DEBUGGENW
 cout << "GenWindowTOIProcessor::Remplissage(" << ks << ") CurWtIndex=" << CurWtIndex << endl;
#endif 

if(ks<SNdeb || ks>SNend) {
  cerr << "GenWindowTOIProcessor::remplissage/Erreur : ks(=" << ks << ") <" 
       << SNdeb << " || ks>" << SNend << endl; 
  throw RangeCheckError("GenWindowTOIProcessor::remplissage : ks<SNdeb || ks>SNend !");
 }
int_8 wsz2=WSize/2;

StartSample = ks - wsz2; // peut etre < snb au debut

// Premier remplissage ???? Gestion de la borne inferieure
if(CurWtIndex<0) {
#ifdef DEBUGGENW
  cout << "GenWindowTOIProcessor::Remplissage 1ere fois" << endl; 
#endif 
  CurWtIndex = 0;
  for(int_8 k=ks-wsz2; k<=ks+wsz2; k++) { // Lecture TOI
    for(int kc=0; kc<NbInput; kc++) {
      if(!WInFlg[kc]) continue;
      if(k>=SNdeb && k<=SNend) {
        getData(kc,k,(WDataIn[kc])(CurWtIndex), (WFlagIn[kc])(CurWtIndex));
      } else {
        (WDataIn[kc])(CurWtIndex) = R8DefVal;
        (WFlagIn[kc])(CurWtIndex) = I8DefVal;
      }
    }
    CurWtIndex++;
  }
  return;
}

// CMV gere decalage seulement si step < wsize sinon copie.
// Faut-il decaler ????
if(CurWtIndex == WSizeTot) { // On decale
#ifdef DEBUGGENW
  cout << "GenWindowTOIProcessor::Remplissage Decalage " << endl; 
#endif 
  for(int kc=0; kc<NbInput; kc++) {
    if(!WInFlg[kc]) continue;
      for(int_8 k=1;k<WSize;k++) { // un en moins car on va remplir apres
        (WDataIn[kc])(k-1) = (WDataIn[kc])(WSizeTot-WSize+k);
        (WFlagIn[kc])(k-1) = (WFlagIn[kc])(WSizeTot-WSize+k);
      }
  }
  CurWtIndex = WSize-1;
}

// Remplissage de ks+wsz2 (dernier element de la fenetre pour ks central)
int_8 kse = ks+wsz2;
#ifdef DEBUGGENW
  cout << "GenWindowTOIProcessor::Normal fill " << endl; 
#endif 
for(int kc=0; kc<NbInput; kc++) {
  if(!WInFlg[kc]) continue;
  if(kse>=SNdeb && kse<=SNend) {
    getData(kc,kse,(WDataIn[kc])(CurWtIndex),(WFlagIn[kc])(CurWtIndex));
  } else {
    (WDataIn[kc])(CurWtIndex) = R8DefVal;
    (WFlagIn[kc])(CurWtIndex) = I8DefVal;
  }
}
CurWtIndex++;

return;
}

void GenWindowTOIProcessor::Ecriture()
{
  int_8 maxlenout = 0;
  int kc;
  for(kc=0; kc<NbOutput; kc++)
    if(WOutFlg[kc] && WPutOutFlg[kc] && (WDataOut[kc].Size() > maxlenout) )
      maxlenout = WDataOut[kc].Size();

  for(int_8 k=0; k<maxlenout; k++) {
    for(int kc=0; kc<NbOutput; kc++) {
      if(!WOutFlg[kc]) continue;
      if(!WPutOutFlg[kc]) continue;
      if(k>=WDataOut[kc].Size()) continue;
      putData(kc, k+OutSample[kc], (WDataOut[kc])(k), (WFlagOut[kc])(k));      
    }
  }
  for(kc=0; kc<NbOutput; kc++)  WPutOutFlg[kc] = false;
}
