/*   Test de GenWindowTOIProcessor (generic processor with window)

----------------   Exemple d'appel  ---------------------
csh> time ./tgenw -intoi bolo -start 1 -end 50000 -wgen 128,1,256 \
           bols.fits xx.fits
// CMV tester wgen 16,64,...
*/



#include "machdefs.h"
#include <math.h>
#include "array.h"
#include <unistd.h>
#include <stdexcept>
#include "toi.h"
#include "toiprocessor.h"
#include "fitstoirdr.h"
#include "fitstoiwtr.h"
#include "toimanager.h"
#include "genwproc.h"
#include "toiseqbuff.h"
#include "timing.h"
#include "sambainit.h"

// ----- Classe de test heritant de GenWindowTOIProcessor -----
class TGenWProc : public GenWindowTOIProcessor {
public:
  TGenWProc(int wsz, int step, int wt);
  virtual void UserInit(int_8 kstart);
  virtual void UserProc(int_8 ks);
  virtual void UserEnd(int_8 kend);

};

TGenWProc::TGenWProc(int wsz, int step, int wt)
  : GenWindowTOIProcessor(1,1,wsz,step,wt)
{
}
void TGenWProc::UserInit(int_8 kstart)
{
  cout << "TGenWProc::UserInit(" << kstart << ")" << endl;
}
void TGenWProc::UserEnd(int_8 kend)
{
  cout << "TGenWProc::UserEnd(" << kend << ")" << endl;
}

void TGenWProc::UserProc(int_8 ks)
{
  if ( (ks == StartSampleNum()) || (ks >= EndSampleNum()-1) || (ks%1000 == 0) )
    cout << "TGenWProc::UserProc(" << ks << ") CenterSample=" << GetCenterSample() << endl;
  if (GetWStep() > 1) {
    TVector<r_8> data;
    TVector<int_8> flag;
    data = GetWData()(Range(GetWSize()/2,0,GetWStep()));
    flag = GetWFlag()(Range(GetWSize()/2,0,GetWStep()));
    PutWData(GetCenterSample(), data, flag);
  }
  else {
    //    PutWData(GetCenterSample(), GetWData()(GetWSize()/2), GetWFlag()(GetWSize()/2));
    r_8 data;
    int_8 flag;
    GetData(GetCenterSample(), data, flag);
    PutWData(GetCenterSample(), data, flag);
  }
}

void Usage(bool fgerr)
{
  cout << endl;
  if (fgerr) {
    cout << " tgenw : Argument Error ! tgenw -h for usage " << endl; 
    exit(1);
  }
  else {
    cout << "\n Usage : tgenw [-dbg] [-start snb] [-end sne] [-intoi name] \n" 
	 << "         [-wtoi sz] [-wgen sz,step,szt] inFitsName outFitsName \n"
	 << "   -dbg : sets TOISeqBuffered debug level to 1 \n"
	 << "   -start snb : sets the start sample num \n"
	 << "   -end sne : sets the end sample num \n"
	 << "   -intoi toiName : select input TOI name (def boloMuV_27)\n"
	 << "   -wtoi sz : sets TOISeqBuff buffer size (def= 8192)\n"
	 << "   -wgen sz,step,szt : sets GenWProc window size, step total size \n"
	 << endl;
    exit(0);
  }
}

int main(int narg, char** arg) {

  if ((narg > 1) && (strcmp(arg[1],"-h") == 0) ) Usage(false);

  cout << "tgenw starting - Decoding arguments " << " narg=" << narg << endl;

  bool fgdbg = false;
  bool fgsetstart = false;
  int wtoi = 8192;
  int wgen = 16;
  int stepgen = 1;
  int wtotgen = 0;
  int istart = 0;
  int iend = 0;
  string infile;
  string outfile;
  string outppfname;
  string intoi = "boloMuV_27";

  if (narg < 3) Usage(true);
  int ko=1;
  // decoding arguments 
  for(int ia=1; ia<narg; ia++) {
    if (strcmp(arg[ia],"-start") == 0) {
      if (ia == narg-1) Usage(true);  // -start est suivi d'un argument 
      istart = atoi(arg[ia+1]); ia++;
      fgsetstart = true;
    }    
    else if (strcmp(arg[ia],"-end") == 0) {
      if (ia == narg-1) Usage(true);  
      iend = atoi(arg[ia+1]); ia++;
    }    
    else if (strcmp(arg[ia],"-wtoi") == 0) {
      if (ia == narg-1) Usage(true);  
      wtoi = atoi(arg[ia+1]); ia++;
    }    
    else if (strcmp(arg[ia],"-wgen") == 0) {
      if (ia == narg-1) Usage(true);  
      sscanf(arg[ia+1],"%d,%d,%d",&wgen,&stepgen,&wtotgen); ia++;
    }    
    else if (strcmp(arg[ia],"-intoi") == 0) {
      if (ia == narg-1) Usage(true);  
      intoi = arg[ia+1]; ia++;
    }    
    else if (strcmp(arg[ia],"-dbg") == 0)  fgdbg = true;

    else { ko = ia; break; }  // Debut des noms
  }

  if (iend < istart) iend = istart+wtoi*10;
  if ((narg-ko) < 2)  Usage(true); 
  infile = arg[ko];
  outfile = arg[ko+1];
  //  outppfname = arg[ko+2];

  cout << " Initializing SOPHYA ... " << endl;
  SophyaInit();
  InitTim();

  cout << ">> tgenw: Infile= " << infile << " outFile=" 
       << outfile << endl; 
  cout << ">>> Window Size WTOI= " << wtoi << " WGenSz= " << wgen
       << " StepGen=" << stepgen << " WTot=" << wtotgen << endl;
  cout << ">>>> InTOIName= " << intoi 
       << "  iStart= " << istart << " iEnd= " << iend << endl;

  try {
    TOIManager* mgr = TOIManager::getManager();
  
    //  mgr->setRequestedSample(11680920,11710584);
    //  mgr->setRequestedSample(104121000, 104946120);
    if (fgsetstart) 
      mgr->setRequestedSample(istart, iend);
  
    FITSTOIReader r(infile); 
    cout << "reader created" << endl;
    FITSTOIWriter w(outfile);
    cout << "fits writer created" << endl;


    TOISeqBuffered * toiin = new TOISeqBuffered("f2in", wtoi);
    if (fgdbg) toiin->setDebugLevel(1);
      
    cout << " Connecting to FitsReader ... " << endl;
    r.addOutput(intoi, toiin);

    TOISeqBuffered * toiout = new TOISeqBuffered("genout", wtoi);
    if (fgdbg) toiout->setDebugLevel(1);
    TGenWProc tgenp(wgen, stepgen, wtotgen);

    cout << " Connecting  TGenWProc ... " << endl;
    tgenp.addInput("in0",toiin);
    tgenp.addOutput("out0",toiout);
    
    cout << tgenp;

    w.addInput("genout", toiout);

    PrtTim("starting threads");
    r.start();
    tgenp.start();
    w.start();


    /*       
    for(int jj=0; jj<3; jj++) {
      cout << *toiin; 
      cout << *toiout; 
      sleep(1);
    }
    */
    
    
    

    mgr->joinAll();
    PrtTim("End threads");

    //    cout << " ------ FITSReaderTOI::PrintStatus() : ----- " << endl;
    //    r.PrintStatus(cout);  
    //    cout << "----- FITSWriterTOI::PrintStatus() : ----- " << endl;
    //    w.PrintStatus(cout);  

    cout << " ------ toiin, toiout Status information ------- " << endl;
    cout << *toiin; 
    cout << *toiout; 
    
    cout << tgenp;
    
  }
  catch (PThrowable & exc) {
    cerr << "\n tgenw: Catched Exception \n" << (string)typeid(exc).name() 
	 << " - Msg= " << exc.Msg() << endl;
  }
  catch (const std::exception & sex) {
    cerr << "\n tgenw: Catched std::exception \n" 
	 << (string)typeid(sex).name() << endl; 
  }
  catch (...) {
    cerr << "\n tgenw: some other exception was caught ! " << endl;
  }

  return(0);
}
