#include <unistd.h>
#include <stdexcept>
#include <stdlib.h>
#include <stdio.h>
#include "toi.h"
#include "toiprocessor.h"
#include "fitstoirdr.h"
#include "fitstoiwtr.h"
#include "toimanager.h"
#include "toiseqbuff.h"

#include "sambainit.h"
#include "toi2map.h"
#include "fitsspherehealpix.h" 
#include "timing.h"

void usage(void);
void usage(void) {
 cout<<"tsttoi2map [-h] [-p lp] [-s samplemin,samplemax] [-w data_window_size]"<<endl
     <<"           [-a label_coord1] [-d label_coord2] [-b label_bolomuv]"<<endl
     <<"           [-n nlat] coord_ini coord_fin fitsin_bolo fitsin_point fitsphout fitsphwout"<<endl
     <<" coord_ini[_fin] = G for Galactic coordinates"<<endl
     <<"                 = Q for equatorial coordinates"<<endl
     <<" coord1 = alpha or longitude ; coord2 = delta or latitude"<<endl;
 return;
}

////////////////////////////////////////////////////////////////
int main(int narg, char** arg) {

TOIManager* mgr = TOIManager::getManager();

//-- Decodage arguments
int lp = 0, width = 8192;
int nlat = 128;   // npixel = 12 * nlat^2
char *label_coord1 = "coord1", *label_coord2 = "coord2", *label_bolomuv = "boloMuV";
long sdeb,sfin;
int c;
while((c = getopt(narg,arg,"hGp:s:w:a:d:b:n:")) != -1) {
  switch (c) {
  case 's' :
    sscanf(optarg,"%ld,%ld",&sdeb,&sfin);
    cout<<"Requested Samples from "<<sdeb<<" , "<<sfin<<endl;
    if(sfin>=sdeb) mgr->setRequestedSample(sdeb,sfin);
    else {cout<<"Bad sample interval "<<endl; exit(-2);}
    break;
  case 'w' :
    sscanf(optarg,"%d",&width);
    if(width<=0) width=8192;
    cout<<"Data window size "<<width<<endl;
    break;
  case 'p' :
    sscanf(optarg,"%d",&lp);
    if(lp<0) lp=0;
    break;
  case 'a' :
    label_coord1 = optarg;
    break;
  case 'd' :
    label_coord2 = optarg;
    break;
  case 'b' :
    label_bolomuv = optarg;
    break;
  case 'n' :
    sscanf(optarg,"%d",&nlat);
    if(nlat<0) nlat=128;
    break;
  case 'h' :
    usage(); exit(-1);
    break;
  default:
    usage(); exit(-1);
  }
}
if(optind+3>=narg) {usage(); exit(-2);}
bool mcoorgal=true;
bool fcoorgal=true;
 
if ( strcmp(arg[optind],"Q") == 0) mcoorgal=false; 
if ( strcmp(arg[optind+1],"Q") == 0) fcoorgal=false; 
 
char * fitsin_bolo = arg[optind+2];
char * fitsin_point = arg[optind+3];
string const fitsphout = arg[optind+4];
string fitsphwout = "";
if(optind+5<narg) fitsphwout = arg[optind+5];

cout<<">>>> tsttoi2map:"<<endl
    <<"Fits Infile(snum,bolomuv)= "<<fitsin_bolo<<endl
    <<"Fits Infile(snum,coord1,coord2)= "<<fitsin_point<<endl
    <<"  ...label_coord1 "<<label_coord1<<"  ,  label_coord2 "<<label_coord2<<endl
    <<"  with coordinates Gal "<<mcoorgal<<endl
    <<"  ...label_bolomuv "<<label_bolomuv<<endl
    <<"Fits Sphere Healpix"<<fitsphout<<endl
    <<"  ...nlat "<<nlat<<endl
    <<"  with coordinates Gal "<<fcoorgal<<endl
    <<"Fits Sphere Healpix Error "<<fitsphwout<<endl;

SophyaInit();
InitTim();

//--------------------------------------------------------------------
try {
//--------------------------------------------------------------------

 // FITS reader
 FITSTOIReader rfitsb(fitsin_bolo);
 int ncolb = rfitsb.getNOut();
 cout<<"Number of columns in fits Infile_bolo : "<<ncolb<<endl;
 if(ncolb<1) exit(-3);

 FITSTOIReader rfitsp(fitsin_point);
 int ncolp = rfitsp.getNOut();
 cout<<"Number of columns in fits Infile_point : "<<ncolp<<endl;
 if(ncolp<2) exit(-3);

 // Creation de la sphere Healpix
 SphereHEALPix<r_8>* sph = new SphereHEALPix<r_8>(nlat);
 cout<<"SphereHEALPix: Type de map : "<<sph->TypeOfMap()<<endl
     <<"               Nombre de pixels : "<<sph->NbPixels()<<endl;

 // Creation de la sphere de poids Healpix
 SphereHEALPix<r_8>* wsph = NULL;
 if(fitsphwout.size()>0) {
   wsph = new SphereHEALPix<r_8>;
   cout<<"SphereHEALPix Weight: Type de map : "<<wsph->TypeOfMap()<<endl
       <<"               Nombre de pixels : "<<wsph->NbPixels()<<endl;
 }

 // TOI Processor
 TOI2Map toi2m(sph,wsph);
 cout<<"TOI2Map created"<<endl;
 toi2m.SetCoorGal(mcoorgal,fcoorgal,2000.);  // equinoxe de ref. 2000. (pour archtoi)

 // Definition des tuyaux
 TOISeqBuffered * toicoord1in = new TOISeqBuffered("toi_coord1_in",width);
 if(lp) toicoord1in->setDebugLevel(1);
 rfitsp.addOutput(label_coord1,toicoord1in);
 toi2m.addInput("Coord1In",toicoord1in);

 TOISeqBuffered * toicoord2in = new TOISeqBuffered("toi_coord2_in",width);
 if(lp) toicoord2in->setDebugLevel(1);
 rfitsp.addOutput(label_coord2,toicoord2in);
 toi2m.addInput("Coord2In",toicoord2in);
 
 TOISeqBuffered * toibolin = new TOISeqBuffered("toi_bolo_in",width);
 if(lp) toibolin->setDebugLevel(1);
 rfitsb.addOutput(label_bolomuv,toibolin);
 toi2m.addInput("BoloIn",toibolin);

 // Run
 cout<<"----- FITSReaderTOI::PrintStatus() : -----"<<endl;
 rfitsp.PrintStatus(cout);
 rfitsb.PrintStatus(cout);

 PrtTim("starting threads");
 rfitsp.start();
 rfitsb.start();
 toi2m.start();

 if(lp>1)
   for(int jjjj=0;jjjj<5;jjjj++) {
     cout<<*toicoord1in; 
     cout<<*toibolin; 
     sleep(2);
   }

 mgr->joinAll();
 PrtTim("End threads");

 // Ecriture de la sphere Healpix sur fits
 {
 FitsOutFile sfits(fitsphout);
 cout<<"tsttoi2map: Creating sphere fits file "<<fitsphout<<endl;
 sfits << *sph;
 }

 // Ecriture de la sphere Healpix sur fits
 if(wsph) {
   FitsOutFile swfits(fitsphwout);
   cout<<"tsttoi2map: Creating sphere weight fits file "<<fitsphwout<<endl;
   swfits << *wsph;
 }

 // Nettoyage
 delete sph;
 if(wsph) delete wsph;

//--------------------------------------------------------------------
} catch (PThrowable & exc) {
 cout<<"\ntsttoi2map: Catched Exception \n"<<(string)typeid(exc).name() 
     <<" - Msg= "<<exc.Msg()<<endl;
} catch (const std::exception & sex) {
 cout<<"\ntsttoi2map: Catched std::exception \n" 
     <<(string)typeid(sex).name()<<endl; 
} catch (...) {
 cout<<"\ntsttoi2map: some other exception was caught ! "<<endl;
}
//--------------------------------------------------------------------

exit(0);
}
