//===========================================================================//
//=========================== pistatmon.h ===================================//
//===========================================================================//

#include "pisysdep.h"
#include "piscdrawwdg.h"
#include PIWIN_H
#include PIBWDG_H
#include PISTDWDG_H

#include "qualite.h"

class PIStatWin;
class PIStatMon;

class PIStatWin : public PIWindow {
public:
                     PIStatWin(PIMsgHandler* par, char* nom, 
			       int sx, int sy, int px, int py);
  virtual            ~PIStatWin();
  virtual void       Process(long msg, PIMsgHandler *sender, void *data);
  void               UpdateInfo(LImageInfo linfoR, LImageInfo linfoB, 
				string var);
  int                ShowWin;

protected:
  PIStatMon*         monitoring1;
  PIStatMon*         monitoring2;
  PIStatMon*         monitoring3;
  PIStatMon*         monitoring4;
  PIButton*          butquit;
  PILabel*           label1;
  PILabel*           label2;
  PILabel*           label3;
  PILabel*           label4;
};

class PIStatMon : public PIScDrawWdg {
public:
                     PIStatMon(PIContainerGen *par, char *nom, 
		               int sx=10, int sy=10, int px=0, int py=0);
  virtual            ~PIStatMon();
  void               SetData(LImageInfo linfoR, LImageInfo linfoB, int choix);
  virtual void       DrawSelf();
  
protected:
  int                ndataR[8];
  int                ndataB[8];
  int                x[16];
  double*            yR[8];
  double*            yB[8];
};

