#include "piperiodx.h"
#include <algo.h>
#include <signal.h>

PIPeriodX::PIPeriodX(int d)
: PIPeriodGen(d), it(-1)
{}

PIPeriodX::~PIPeriodX()
{}

void
PIPeriodX::Start()
{
  if (it < 0) {
    if (!actifs) actifs = new PIPeriodList;
    it = 0;
    if (actifs->size() == 0) {
      signal(SIGALRM, CallBack);
      alarm(1);
    }
    actifs->push_back(this);
  }
}

void
PIPeriodX::Stop()
{
  if (it >= 0) {
    it = -1;
    remove(actifs->begin(), actifs->end(), this);
    if (actifs->size() == 0) {
      signal(SIGALRM, NULL);
      delete actifs;
      actifs = NULL;
    }
  }
}

PIPeriodList* PIPeriodX::actifs = NULL;

void PIPeriodX::CallBack(int)
{
  if (!actifs) return;

  for (PIPeriodList::iterator i = actifs->begin(); i != actifs->end(); i++) {
    PIPeriodX* p = (PIPeriodX*) *i;
    p->it ++;
    if (p->it >= p->dt) {
      p->it = 0;
      p->DoPeriodic();
    }
  }
  alarm(1);
}

