//===========================================================================//
//================================= piqualmon.cc ============================//
//===========================================================================//

#include <stdio.h>
#include "piqualmon.h"
#include "qualite.h"

//========================= classe PIQualiteWin =============================//
PIQualiteWin::PIQualiteWin(PIMsgHandler *par)
:PIWindow(par, "Qualite Suivi", PIWK_normal, 660, 280, 160, 0)
{
  ccd = 0;
  var1 = "FOND";
  var2 = "FOND";
  monitoring1    = new PIQualiteMon(this, "Fond", 300, 200, 20, 40);
  monitoring2    = new PIQualiteMon(this, "Fond", 300, 200, 340,40);
  menuccd        = new PIPUMenu(this, "CCD");
  menuccd->AppendItem("tous", 80000);
  menuccd->AppendItem("1", 80001);
  menuccd->AppendItem("2", 80002);
  menuccd->AppendItem("3", 80003);
  menuccd->AppendItem("4", 80004);
  menuccd->AppendItem("5", 80005);
  menuccd->AppendItem("6", 80006);
  menuccd->AppendItem("7", 80007);
  menuccd->AppendItem("8", 80008);

  menudata[0]    = new PIPUMenu(this, "Data");
  menudata[0]->AppendItem("FOND" , 90001);
  menudata[0]->AppendItem("SIGMA", 90002);
  menudata[0]->AppendItem("NSTAR", 90003);

  menudata[1]    = new PIPUMenu(this, "Data");
  menudata[1]->AppendItem("FOND" , 90011);
  menudata[1]->AppendItem("SIGMA", 90012);
  menudata[1]->AppendItem("NSTAR", 90013);

  optMenuccd     = new PIOptMenu    (this, menuccd, 80, 20, 290, 15); 
  optMenudata[0] = new PIOptMenu    (this, menudata[0], 80, 20, 130, 250); 
  optMenudata[1] = new PIOptMenu    (this, menudata[1], 80, 20, 450, 250); 
  labccd         = new PILabel      (this, "CCD :", 50, 20, 240, 15);
  labR           = new PILabel      (this, "Log R : ", 50, 20, 20, 3);
  labB           = new PILabel      (this, "Log B : ", 50, 20, 20, 20);
  labfileR       = new PILabel      (this, "FileR", 70, 20, 75, 3);
  labfileB       = new PILabel      (this, "FileB", 70, 20, 75, 20);
}

PIQualiteWin::~PIQualiteWin()
{
  delete labfileB;
  delete labfileR;
  delete labB;
  delete labR;
  delete labccd;
  delete optMenudata[0];
  delete optMenudata[1];
  delete menudata[0];
  delete menudata[1];
  delete optMenuccd;
  delete menuccd;
  delete monitoring1;
  delete monitoring2;
}

void PIQualiteWin::UpdateInfo(LImageInfo linfo, char color, string labflnm)
{  
  if (color == 'r') {
    linfoR = linfo;
    labfileR->SetLabel(labflnm);
  }
  else if (color == 'b') {
    linfoB = linfo;
    labfileB->SetLabel(labflnm);
  }
  monitoring1->SetData(linfoR, linfoB, var1, ccd);
  monitoring2->SetData(linfoR, linfoB, var2, ccd);
}

void PIQualiteWin::Process(long msg, PIMsgHandler *, void *)
{
  switch (msg) {
  case 80000:
  case 80001: case 80002: case 80003: case 80004: 
  case 80005: case 80006: case 80007: case 80008:
    ccd = msg - 80000;
    monitoring1->SetData(linfoR, linfoB, var1, ccd);
    monitoring2->SetData(linfoR, linfoB, var2, ccd);
    break;
  case 90001:
    var1 = "FOND";
    monitoring1->SetData(linfoR, linfoB, var1, ccd);
    break;
  case 90002:
    var1 = "SIGMA";
    monitoring1->SetData(linfoR, linfoB, var1, ccd);
    break;
  case 90003:
    var1 = "NSTAR";
    monitoring1->SetData(linfoR, linfoB, var1, ccd);
    break;
  case 90011:
    var2 = "FOND";
    monitoring2->SetData(linfoR, linfoB, var2, ccd);
    break;
  case 90012:
    var2 = "SIGMA";
    monitoring2->SetData(linfoR, linfoB, var2, ccd);
    break;
  case 90013:
    var2 = "NSTAR";
    monitoring2->SetData(linfoR, linfoB, var2, ccd);
    break;

  default:
    cout << "Message " << msg << " non interprete" << endl;    
  }   
}

//========================== classe PIQualiteMon ============================//

PIQualiteMon::PIQualiteMon(PIContainerGen *par, char *nom, 
			   int sx, int sy, int px, int py)
: PIScDrawWdg(par, nom, sx, sy, px, py)
{
  SetAxesFlags(kBoxAxes | kTicks | kLabels);
  ndataR = ndataB = 0;
  xR = xB = NULL;
  y1R = y1B = NULL;
  y2R = y2B = NULL;
}

PIQualiteMon::~PIQualiteMon()
{
 if (xR != NULL) delete[] xR;
 if (xB != NULL) delete[] xB;
 if (y1R != NULL) delete[] y1R;
 if (y1B != NULL) delete[] y1B;
 if (y2R != NULL) delete[] y2R;
 if (y2B != NULL) delete[] y2B;
}

void PIQualiteMon::SetData(LImageInfo linfoR, LImageInfo linfoB, string var, 
			   int ccd)
{
  ndataR = (int)linfoR.size();
  ndataB = (int)linfoB.size();
  
  // mise a zero des donnees deja existantes

  if (xR  != NULL) { delete[] xR;  xR  = NULL; }
  if (y1R != NULL) { delete[] y1R; y1R = NULL; }
  if (y2R != NULL) { delete[] y2R; y2R = NULL; }
  if (ndataR > 0) {
    if((xR = new double[ndataR]) == NULL) {
      printf("PIQualiteMon::SetData_Error memoire insuffisante pour xR\n");
      return;
    }
    if((y1R = new double[ndataR]) == NULL) {
      printf("PIQualiteMon::SetData_Error memoire insuffisante pour y1R\n");
      return;
    }
    if (var == "SIGMA") if((y2R = new double[ndataR]) == NULL) {
      printf("PIQualiteMon::SetData_Error memoire insuffisante pour y2R\n");
      return;
    }
  }
   
  if (xB  != NULL) { delete[] xB;  xB  = NULL; }
  if (y1B != NULL) { delete[] y1B; y1B = NULL; }
  if (y2B != NULL) { delete[] y2B; y2B = NULL; }
  if (ndataB >0) {
    if((xB = new double[ndataB]) == NULL) {
      printf("PIQualiteMon::SetData_Error memoire insuffisante pour xB\n");
      return;
    }
    if((y1B = new double[ndataB]) == NULL) {
      printf("PIQualiteMon::SetData_Error memoire insuffisante pour y1B\n");
      return;
    }
    if (var == "SIGMA") if((y2B = new double[ndataB]) == NULL) {
      printf("PIQualiteMon::SetData_Error memoire insuffisante pour y2B\n");
      return;
    }
  }

  // remplissage avec nouvelles valeurs 

  ndataR = ndataB = 0;
  float valmin=100000, valmax=0, heuremin=36, heuremax=-36;
  char time[10];
  float heure,min,sec;
  for (LImageInfo::iterator i=linfoR.begin(); i!=linfoR.end(); i++) {
    if ((*i).nomimg.ccd == ccd || ccd == 0) {
      (*i).date.GetTimeStr(time);
      sscanf(time, "%f:%f:%f", &heure, &min, &sec);
      heure = heure + min/60 + sec/3600;
      if (heure > 12) heure -= 24; 
      xR[ndataR] = heure;
      if (heure > heuremax) heuremax = heure;
      if (heure < heuremin) heuremin = heure;
      if (var == "FOND") {
	if((y1R[ndataR] = (*i).fond) == -1) continue;
      }
      else if (var == "SIGMA") {
 	if((y1R[ndataR] = (*i).sigmaX) == -1) continue;
	if((y2R[ndataR] = (*i).sigmaY) == -1) continue;
	if (y2R[ndataR] > valmax) valmax = y2R[ndataR];
	if (y2R[ndataR] < valmin) valmin = y2R[ndataR] ;
      }
      else if (var == "NSTAR") {
	if((y1R[ndataR] = (*i).nStars) == -1) continue;
      }
      if (y1R[ndataR] > valmax) valmax = y1R[ndataR];
      if (y1R[ndataR] < valmin) valmin = y1R[ndataR];
      ndataR++;
    }
  }
  for (LImageInfo::iterator i=linfoB.begin(); i!=linfoB.end(); i++) {
    if ((*i).nomimg.ccd == ccd || ccd == 0) {
      (*i).date.GetTimeStr(time);
      sscanf(time, "%f:%f:%f", &heure, &min, &sec);
      heure = heure + min/60 + sec/3600;
      xB[ndataB] = heure;
      if (heure > 12) heure -= 24; 
      if (heure > heuremax) heuremax = heure;
      if (heure < heuremin) heuremin = heure;
      if (var == "FOND") {
	if((y1B[ndataB] = (*i).fond) == -1) continue;
      }
      else if (var == "SIGMA") {
	if((y1B[ndataB] = (*i).sigmaX) == -1) continue;
	if((y2B[ndataB] = (*i).sigmaY) == -1) continue;
	if (y2B[ndataB] > valmax) valmax = y2B[ndataB];
	if (y2B[ndataB] < valmin) valmin = y2B[ndataB];
      }
      else if (var == "NSTAR") {
 	if((y1B[ndataB] = (*i).nStars) == -1) continue;
     }
      if (y1B[ndataB] > valmax) valmax = y1B[ndataB];
      if (y1B[ndataB] < valmin) valmin = y1B[ndataB];
      ndataB++;
    }
  }
  float scale = heuremax-heuremin;
  if (scale == 0) scale = 10;
  SetLimits(heuremin-scale/10, heuremax+scale/10, valmin*.9, valmax*1.1);

  Refresh();
}

void PIQualiteMon::DrawSelf()
{
  SelMarker(5,PI_FCircleMarker);
  SelForeground(PI_Red);
  if(ndataR) for (int i=0;i<ndataR;i++) {
    ScDrawMarker(xR[i],y1R[i]);
    if(y2R != NULL) ScDrawFCircle(xR[i],y2R[i],0.2);
  }
  SelMarker(5,PI_FCircleMarker);
  SelForeground(PI_Blue);
  if(ndataB) for (int i=0;i<ndataB;i++) {
    ScDrawMarker(xB[i],y1B[i]);
    if(y2B != NULL) ScDrawFCircle(xB[i],y2B[i],0.2);
  }

  SelForeground(PI_Black);
}
