// This may look like C code, but it is really -*- C++ -*-
//===========================================================================//
//================================= piqualmon.h =============================//
//===========================================================================//


#include "pisysdep.h"
#include "piscdrawwdg.h"
#include PISTDWDG_H
#include PIOPTMENU_H
#include PIWIN_H
#include PIBWDG_H

#include "qualite.h"

class PIQualiteWin;
class PIQualiteMon;

class PIQualiteWin : public PIWindow {
public:
                      PIQualiteWin(PIMsgHandler* par);
  virtual             ~PIQualiteWin();
  virtual void        UpdateInfo(LImageInfo linfo, char color, string labflnm);
  virtual void        Process(long msg, PIMsgHandler *sender, void *data);

protected:
  PIQualiteMon*       monitoring1;
  PIQualiteMon*       monitoring2;
  PIOptMenu*          optMenuccd;
  PIPUMenu*           menuccd;
  PIOptMenu*          optMenudata[2];
  PIPUMenu*           menudata[2];
  PILabel*            labccd;
  PILabel*            labR;
  PILabel*            labB;
  PILabel*            labfileR;
  PILabel*            labfileB;
  LImageInfo          linfoR;
  LImageInfo          linfoB;
  int                 ccd;  // 0 pour tous
  string              var1;
  string              var2;
};

class PIQualiteMon : public PIScDrawWdg {
public:
                   PIQualiteMon(PIContainerGen *par, char *nom, 
				int sx=10, int sy=10, int px=0, int py=0);
  virtual          ~PIQualiteMon();

  virtual void     DrawSelf();
  void             SetData(LImageInfo linfoR, LImageInfo linfoB, string var, 
			   int ccd);
  
protected:
  int             ndataR;
  int             ndataB;
  double*         xR;
  double*         xB;
  double*         y1R;
  double*         y2R;
  double*         y1B;
  double*         y2B;
};

