//===========================================================================//
//=========================== pistatmon.cc ==================================//
//===========================================================================//

#include "pistatmon.h"
#include "qualite.h"

//=========================== classe PIStatWin ==============================//

PIStatWin::PIStatWin(PIMsgHandler *par, char* nom, 
		     int sx, int sy, int px, int py)
:PIWindow(par, nom, PIWK_normal, sx, sy, px, py)
{
  monitoring1 = new PIStatMon  (this, "Dead", 235, 160, 10, 30);
  monitoring2 = new PIStatMon  (this, "Sat", 235, 160, 255, 30);
  butquit     = new PIButton   (this, "QUIT", 1010, 45,20,10,5);
  string Nom = nom;
  if (Nom.substr(Nom.rfind(" ")+1,3) == "pix") {
    label1      = new PILabel    (this, "Pix. nuls (%)", 235,20,10,5);
    label2      = new PILabel    (this, "Pix. sat. (%)", 235,20,255,5);
  }
  else if (Nom.substr(Nom.rfind(" ")+1,3) == "col") {
    label1      = new PILabel   (this, "Nb colonnes nulles", 235,20,10,5);
    label2      = new PILabel   (this, "Nb colonnes saturees", 235,20,255,5);
    label3      = new PILabel   (this, "Nb discontinuites haut",235,20,10,205);
    label4      = new PILabel   (this, "Nb discontinuites bas",235,20,255,205);
    monitoring3 = new PIStatMon (this, "Up", 235, 160, 10, 230);
    monitoring4 = new PIStatMon (this, "Down", 235, 160, 255, 230);
  }
  else cout << "PROBLEME : " << Nom.substr(Nom.rfind(" ")+1,3) 
            << "ni pix ni col" << endl;

  ShowWin = 0;
}

PIStatWin::~PIStatWin()
{
  delete butquit;
  delete label1;
  delete label2;
  if (label3 != NULL) delete label3;
  if (label4 != NULL) delete label4;
  delete monitoring1;
  delete monitoring2;
  if (monitoring3 != NULL) delete monitoring3;
  if (monitoring4 != NULL) delete monitoring4;
}

void PIStatWin::UpdateInfo(LImageInfo linfoR, LImageInfo linfoB, string var)
{
  int choix;
  if(var == "pixels") choix = 10;
  else if(var == "colonnes") {
    choix = 100;
    monitoring3->SetData(linfoR, linfoB, choix+3);
    monitoring4->SetData(linfoR, linfoB, choix+4);
  }
  else cout << "Variable " << var << " non reconnue" << endl;
  monitoring1->SetData(linfoR, linfoB, choix+1);
  monitoring2->SetData(linfoR, linfoB, choix+2);
  if (ShowWin) {
    monitoring1->Refresh();
    monitoring2->Refresh();
    if(var == "colonnes") {
      monitoring3->Refresh();
      monitoring4->Refresh();
    }
  }
}

void PIStatWin::Process(long msg, PIMsgHandler *, void *)
{
  switch (msg) {
  case 1010:
    this->Hide();
    ShowWin = 0;
    break;

  default:
    cout << "Message " << msg << " non interprete" << endl;
  }
}

//=========================== classe PIStatMon ==============================//

PIStatMon::PIStatMon(PIContainerGen *par, char *nom, int sx, int sy, 
		     int px, int py)
: PIScDrawWdg(par, nom, sx, sy, px, py)
{
  SetAxesFlags(kBoxAxes | kTicks | kLabels);
  for (int i=0;i<8;i++) {
    ndataR[i] = ndataB[i] = 0;
    yR[i] = yB[i] = NULL;
  }
  for (int i=0;i<16;i++) x[i] = i;
}

PIStatMon::~PIStatMon()
{
  for(int i=0; i<8; i++) {
    if (yR[i] != NULL) delete[] yR[i];
    if (yB[i] != NULL) delete[] yB[i];
  }
}

void PIStatMon::SetData(LImageInfo linfoR, LImageInfo linfoB, int choix)
{
  for (int i=0;i<8;i++) {
    ndataR[i] = (int)linfoR.size();
    ndataB[i] = (int)linfoB.size();
    if((yR[i] = new double[ndataR[i]]) == NULL) {
      printf("PIStatMon::SetData_Error memoire insuffisante pour yR\n");
      return;
    }
    if((yB[i] = new double[ndataB[i]]) == NULL) {
      printf("PIStatMon::SetData_Error memoire insuffisante pour yB\n");
      return;
    }
  }

  for(int i=0;i<8;i++) ndataR[i] = ndataB[i] = 0;
  int ccd;

  float valmin=100000, valmax=0;
  switch(choix) {
  case 11:
    for (LImageInfo::iterator i=linfoR.begin(); i!=linfoR.end(); i++) {
      if ((ccd = (*i).nomimg.ccd) >=8) ccd -= 8;             //TEMPORAIRE
      if((*i).fracNul != -1) yR[ccd][ndataR[ccd]] = (*i).fracNul * 100;
      if (yR[ccd][ndataR[ccd]] > valmax) valmax = yR[ccd][ndataR[ccd]];
      if (yR[ccd][ndataR[ccd]] < valmin) valmin = yR[ccd][ndataR[ccd]] ;
      ndataR[ccd]++;
    }
    for (LImageInfo::iterator i=linfoB.begin(); i!=linfoB.end(); i++) {
      if ((ccd = (*i).nomimg.ccd) >=8) ccd -= 8;             //TEMPORAIRE
      if((*i).fracNul != -1) yB[ccd][ndataB[ccd]] = (*i).fracNul * 100;
      if (yB[ccd][ndataB[ccd]] > valmax) valmax = yB[ccd][ndataB[ccd]];
      if (yB[ccd][ndataB[ccd]] < valmin) valmin = yB[ccd][ndataB[ccd]] ;
      ndataB[ccd]++;
    }
    SetLimits(0, 15, valmin*.9, valmax*1.1);
    break;
  case 12:
    for (LImageInfo::iterator i=linfoR.begin(); i!=linfoR.end(); i++) {
      if ((ccd = (*i).nomimg.ccd) >=8) ccd -= 8;             //TEMPORAIRE
      if((*i).fracSat != -1) yR[ccd][ndataR[ccd]] = (*i).fracSat * 100;
      if (yR[ccd][ndataR[ccd]] > valmax) valmax = yR[ccd][ndataR[ccd]];
      if (yR[ccd][ndataR[ccd]] < valmin) valmin = yR[ccd][ndataR[ccd]] ;
      ndataR[ccd]++;
    }
    for (LImageInfo::iterator i=linfoB.begin(); i!=linfoB.end(); i++) {
      if ((ccd = (*i).nomimg.ccd) >=8) ccd -= 8;             //TEMPORAIRE
      if((*i).fracSat != -1) yB[ccd][ndataB[ccd]] = (*i).fracSat * 100;
      if (yB[ccd][ndataB[ccd]] > valmax) valmax = yB[ccd][ndataB[ccd]];
      if (yB[ccd][ndataB[ccd]] < valmin) valmin = yB[ccd][ndataB[ccd]] ;
      ndataB[ccd]++;
    }
    SetLimits(0, 15, valmin*.9, valmax*1.1);
    break;
  case 101:
    for (LImageInfo::iterator i=linfoR.begin(); i!=linfoR.end(); i++) {
      if ((ccd = (*i).nomimg.ccd) >=8) ccd -= 8;             //TEMPORAIRE
      if((*i).nDeadCol != -1) yR[ccd][ndataR[ccd]] = (*i).nDeadCol;
      if (yR[ccd][ndataR[ccd]] > valmax) valmax = yR[ccd][ndataR[ccd]];
      if (yR[ccd][ndataR[ccd]] < valmin) valmin = yR[ccd][ndataR[ccd]] ;
      ndataR[ccd]++;
    }
    for (LImageInfo::iterator i=linfoB.begin(); i!=linfoB.end(); i++) {
      if ((ccd = (*i).nomimg.ccd) >=8) ccd -= 8;             //TEMPORAIRE
      if((*i).nDeadCol != -1) yB[ccd][ndataB[ccd]] = (*i).nDeadCol;
      if (yB[ccd][ndataB[ccd]] > valmax) valmax = yB[ccd][ndataB[ccd]];
      if (yB[ccd][ndataB[ccd]] < valmin) valmin = yB[ccd][ndataB[ccd]] ;
      ndataB[ccd]++;
    }
    SetLimits(0, 15, valmin*.9, valmax*1.1);
    break;
  case 102:
    for (LImageInfo::iterator i=linfoR.begin(); i!=linfoR.end(); i++) {
      if ((ccd = (*i).nomimg.ccd) >=8) ccd -= 8;             //TEMPORAIRE
      if((*i).nSatCol != -1) yR[ccd][ndataR[ccd]] = (*i).nSatCol;
      if (yR[ccd][ndataR[ccd]] > valmax) valmax = yR[ccd][ndataR[ccd]];
      if (yR[ccd][ndataR[ccd]] < valmin) valmin = yR[ccd][ndataR[ccd]] ;
      ndataR[ccd]++;
     }
    for (LImageInfo::iterator i=linfoB.begin(); i!=linfoB.end(); i++) {
      if ((ccd = (*i).nomimg.ccd) >=8) ccd -= 8;             //TEMPORAIRE
      if((*i).nSatCol != -1) yB[ccd][ndataB[ccd]] = (*i).nSatCol;
      if (yB[ccd][ndataB[ccd]] > valmax) valmax = yB[ccd][ndataB[ccd]];
      if (yB[ccd][ndataB[ccd]] < valmin) valmin = yB[ccd][ndataB[ccd]] ;
      ndataB[ccd]++;
    }
    SetLimits(0, 15, valmin*.9, valmax*1.1);
    break;
  case 103:
    for (LImageInfo::iterator i=linfoR.begin(); i!=linfoR.end(); i++) {
      if ((ccd = (*i).nomimg.ccd) >=8) ccd -= 8;             //TEMPORAIRE
      if((*i).nUpCol != -1) yR[ccd][ndataR[ccd]] = (*i).nUpCol;
      if (yR[ccd][ndataR[ccd]] > valmax) valmax = yR[ccd][ndataR[ccd]];
      if (yR[ccd][ndataR[ccd]] < valmin) valmin = yR[ccd][ndataR[ccd]] ;
      ndataR[ccd]++;
    }
    for (LImageInfo::iterator i=linfoB.begin(); i!=linfoB.end(); i++) {
      if ((ccd = (*i).nomimg.ccd) >=8) ccd -= 8;             //TEMPORAIRE
      if((*i).nUpCol != -1) yB[ccd][ndataB[ccd]] = (*i).nUpCol;
      if (yB[ccd][ndataB[ccd]] > valmax) valmax = yB[ccd][ndataB[ccd]];
      if (yB[ccd][ndataB[ccd]] < valmin) valmin = yB[ccd][ndataB[ccd]] ;
      ndataB[ccd]++;
    }
    SetLimits(0, 15, valmin*.9, valmax*1.1);
    break;
  case 104:
    for (LImageInfo::iterator i=linfoR.begin(); i!=linfoR.end(); i++) {
      if ((ccd = (*i).nomimg.ccd) >=8) ccd -= 8;             //TEMPORAIRE
      if((*i).nDownCol != -1) yR[ccd][ndataR[ccd]] = (*i).nDownCol;
      if (yR[ccd][ndataR[ccd]] > valmax) valmax = yR[ccd][ndataR[ccd]];
      if (yR[ccd][ndataR[ccd]] < valmin) valmin = yR[ccd][ndataR[ccd]] ;
      ndataR[ccd]++;
    }
    for (LImageInfo::iterator i=linfoB.begin(); i!=linfoB.end(); i++) {
      if ((ccd = (*i).nomimg.ccd) >=8) ccd -= 8;             //TEMPORAIRE
      if((*i).nDownCol != -1) yB[ccd][ndataB[ccd]] = (*i).nDownCol;
      if (yB[ccd][ndataB[ccd]] > valmax) valmax = yB[ccd][ndataB[ccd]];

      if (yB[ccd][ndataB[ccd]] < valmin) valmin = yB[ccd][ndataB[ccd]] ;
      ndataB[ccd]++;
    }
    SetLimits(0, 15, valmin*.9, valmax*1.1);
    break;
    
  default:
    cout << "Choix " << choix << " non interprete" << endl;      
  }
}

void PIStatMon::DrawSelf()
{
  for(int i=0;i<8;i++) {
    if(ndataR[i]) {    // on imprime donnees sur camera ROUGE
      SelForeground(PI_Black);
      SelMarker(5,PI_FCircleMarker);
      for(int j=0;j<ndataR[i]-1;j++) ScDrawMarker(x[i],yR[i][j]);
      SelForeground(PI_Red);
      SelMarker(7,PI_FCircleMarker);
      ScDrawMarker(x[i],yR[i][ndataR[i]-1]);
    }
    if(ndataB[i]) {    // on imprime donnees sur camera BLEU
      SelForeground(PI_Black);
      SelMarker(5,PI_FCircleMarker);
      for(int j=0;j<ndataB[i]-1;j++) ScDrawMarker(x[i+8],yB[i][j]);
      SelForeground(PI_Blue);
      SelMarker(7,PI_FCircleMarker);
      ScDrawMarker(x[i+8],yB[i][ndataB[i]-1]);
    }
  }
  SelForeground(PI_Grey);
  SelLine(PI_ThinLine);
  ScDrawLine(7.5,-100,7.5,5000);
  SelLine(PI_NormalLine);
  SelForeground(PI_Black);
  DrawString(190,155,"ccd");
}

