// This may look like C code, but it is really -*- C++ -*-
// Module PI : Peida Interactive     PIColorMap
// Gestion de table de couleurs        96
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#ifndef PICMAP_H_SEEN
#define PICMAP_H_SEEN

#include "pisysdep.h"
#include PICMAPNTV_H

enum CMapId
 {
 CMAP_OTHER       = 0, 
 CMAP_GREY32      = 1,     // 32 niveaux de gris                    * permanent
 CMAP_GREYINV32   = 2,     // 32 niveaux gris du blan au noir       * permanent
 CMAP_COLRJ32     = 3,     // 32 couleurs, du Rouge au Jaune/blanc  * permanent
 CMAP_COLBR32     = 4,     // 32 couleurs du bleu au rouge
 CMAP_COLRV32     = 5,     // 32 couleurs 
 CMAP_GREY128     = 6,     // 128 couleurs  niveaux de gris
 CMAP_GREYINV128  = 7,     //    "     "      "      " 
 CMAP_COLRJ128    = 8,     // 128 couleurs du rouge au jaune/blanc
 CMAP_COLBR128    = 9,     // 128 couleurs du bleu au rouge

 // Tables de couleur importees de MIDAS   256 couleurs
 CMAP_MIDAS_Pastel    = 101,  // Bleu-Violet-Rouge-Jaune (pastel.lutlis)
 CMAP_MIDAS_Heat      = 102,  // Noir-Rouge-Orange-Blanc (heat.lutlis)
 CMAP_MIDAS_Rainbow3  = 103,  // Noir-Bleu-Vert-Jaune-Rouge-Violet-Blanc (rainbow3.lutlis)
 CMAP_MIDAS_BlueRed   = 104,  // Bleu-Violet-Rouge (idl11.lutlis)
 CMAP_MIDAS_BlueWhite = 105,  // Noir-Bleu-Blanc (blulut.lutlis)
 CMAP_MIDAS_Stairs8   = 106,  // escalier (stairs8.lutlis)
 CMAP_MIDAS_Stairs9   = 107,  // escalier (stairs9.lutlis)
 CMAP_MIDAS_StairCase = 108,  //          (staircase.lutlis)
 CMAP_MIDAS_Color     = 109,  //          (color.lutlis)
 CMAP_MIDAS_ManyCol   = 110,  // Repetition de motif (manycol.lutlis)
 CMAP_MIDAS_Idl14     = 111,  //  (idl14.lutlis)
 CMAP_MIDAS_Idl15     = 112,  //  (idl15.lutlis)

 //  Table simple a 16 couleurs 
 CMAP_COL16       = 999        // 16 Couleurs Arcenciel
 };


class PIColorMap : public PIColorMapNative {
public:
  PIColorMap(CMapId);
  PIColorMap(string const& nom, int nCol); 
  PIColorMap(PIColorMap&);
  virtual ~PIColorMap();

  static void CleanColorMaps();
  static int  NumberStandardColorMaps();
  static CMapId GetStandardColorMapId(int num);
  static string GetStandardColorMapName(int num);
  static int    ColorMapId2Num(PIColorMap const & cmap);

protected:
  PIColorMap(CMapId id, int nc, string const& nom);  // Fait l'allocation des couleurs     
  void     MakeColMap();

  int mCTId;    // Pour tenir trace de la derniere table qui doit liberer les couleurs 
};

#endif

