/* Interface Fits BINARY/ASCII Table     cmv 21/05/2001 */
#include "machdefs.h"
#include <stdlib.h>
#include <stdio.h>
#include "pexceptions.h"
#include "fbtntintf.h"

//////////////////////////////////////////////////////////////
FitsBTNtuIntf::FitsBTNtuIntf(string fname,int ihdu,uint_4 blen,uint_2 lp)
{
 BuffLen = (blen==0) ? 100 : blen;
 DbgLevel = lp;
 SetNulVal();
 FitsFN = fname;
 IHdu = ihdu;
 Init();
}

FitsBTNtuIntf::FitsBTNtuIntf(char * cfname,int ihdu,uint_4 blen,uint_2 lp)
{
 BuffLen = (blen==0) ? 100 : blen;
 DbgLevel = lp;
 SetNulVal();
 FitsFN = cfname;
 IHdu = ihdu;
 Init();
}

FitsBTNtuIntf::FitsBTNtuIntf(FitsBTNtuIntf& fbtnt)
{
 BuffLen = fbtnt.BuffLen;
 DbgLevel = fbtnt.DbgLevel;
 NulVal = fbtnt.NulVal;
 FitsFN = fbtnt.FitsFN;
 IHdu = fbtnt.IHdu;
 Init();
}

FitsBTNtuIntf::FitsBTNtuIntf()
{
 BuffLen = 100;
 DbgLevel = 0;
 SetNulVal();
 FitsFN = "";
 IHdu = -1;
 Init();
}

FitsBTNtuIntf::~FitsBTNtuIntf()
{
 Delete();
}

//////////////////////////////////////////////////////////////
void FitsBTNtuIntf::Init()
{
 NBcol = 0; NBline = 0;
 LineDeb = LineFin = -1;
 ColName.resize(0);
 ColReadable = NULL;
 Buffer = NULL;
 mRet = NULL;
 NFitsRead = 0;

 if(FitsFN.size() <= 0 ) {
   FitsPtr = NULL;
   IHdu = -1;
   return;
 }

 //////////////////////////
 // Ouverture du fichier //
 //////////////////////////

 int sta=0,nhdu,hdutype;
 const char * cfitsfn = FitsFN.c_str();

 // Open fits
 if(fits_open_file(&FitsPtr,cfitsfn,READONLY,&sta)) printerror(sta);

 // Get number of hdu
 if(fits_get_num_hdus(FitsPtr,&nhdu,&sta)) printerror(sta);
 if(DbgLevel) cout<<"FitsBTNtuIntf::Init  nhdu="<<nhdu<<endl;
 if(nhdu<=0) {Delete(); return;}

 // Get HDU for bin table
 // si IHdu <=0 on cherche la 1ere bin table
 // sinon on se positionne sur IHdu
 if(IHdu<=0 || IHdu>nhdu)
   for(int ihdu=1;ihdu<=nhdu;ihdu++) {
     if(fits_movabs_hdu(FitsPtr,ihdu,&hdutype,&sta)) printerror(sta);
     if(DbgLevel) cout<<"...Init ihdu="
                      <<ihdu<<" hdutype="<<hdutype<<endl;
     if(hdutype==BINARY_TBL || hdutype==ASCII_TBL) {IHdu = ihdu; break;}
   }
 if(IHdu<=0 || IHdu>nhdu) {
   cout<<"NO BINARY or ASCII hdu found"<<endl;
   Delete();
   return;
 }
 if(fits_movabs_hdu(FitsPtr,IHdu,&hdutype,&sta)) printerror(sta);
 if(hdutype!=BINARY_TBL && hdutype!=ASCII_TBL) {Delete(); return;}

 // Get number of columns
 if(fits_get_num_cols(FitsPtr,&NBcol,&sta)) printerror(sta);
 if(DbgLevel) cout<<"...Init  NBcol="<<NBcol<<endl;
 if(NBcol<1) {Delete(); return;}
 mRet = new double[NBcol];
 ColReadable = new bool[NBcol];
 Buffer = new double*[NBcol];
 for(int icol=0;icol<NBcol;icol++)
   {Buffer[icol]=NULL; ColReadable[icol]=false;}

 // Get number of rows
 if(fits_get_num_rows(FitsPtr,&NBline,&sta)) printerror(sta);
 if(DbgLevel) cout<<"...Init  NBline="<<NBline<<endl;
 if(NBline<1) {Delete(); return;}

 // Get column infos
 for(int icol=0;icol<NBcol;icol++) {
   int colnum,typecode;
   char templt[16], colname[256];
   sprintf(templt,"%d",icol+1);
   if(fits_get_colname(FitsPtr,CASESEN,templt,colname,&colnum,&sta))
     printerror(sta);
   ColName.push_back(colname);
   if(fits_get_coltype(FitsPtr,icol+1,&typecode,NULL,NULL,&sta))
     printerror(sta);
   if(typecode!=TSTRING && typecode!=TCOMPLEX &&  typecode!=TDBLCOMPLEX)
        ColReadable[icol] = true;
   if(DbgLevel)
     cout<<"...Init col="<<icol+1
	 <<" name="<<ColName[icol]
         <<" typecode="<<typecode<<" (readable="
         <<ColReadable[icol]<<")"<<endl;
   // Prepare buffer
   if(ColReadable[icol]) Buffer[icol] = new double[BuffLen];
 }

}

void FitsBTNtuIntf::Delete()
{
  if(Buffer!=NULL) {
   for(int i=0;i<NBcol;i++)
     if(Buffer[i]!=NULL) delete [] Buffer[i];
   delete [] Buffer;
  }
 if(mRet!=NULL) delete [] mRet;
 if(ColReadable!=NULL) delete [] ColReadable;

 int sta = 0;
 if(fits_close_file(FitsPtr,&sta)) printerror(sta);
 FitsPtr = NULL;
}

/////////////////////////////////////////////////
uint_4 FitsBTNtuIntf::NbLines() const
{
 return NBline;
}

uint_4 FitsBTNtuIntf::NbColumns() const
{
 return NBcol;
}

r_8 * FitsBTNtuIntf::GetLineD(int n) const
// Attention: n [0,NBline[, cfistio veut [1,NBline]
{
 int sta=0,anynul;
 if(n<0 || n>=NBline) return NULL;

 // Pas de bufferisation, on lit betement
 if(BuffLen==1) {
   NFitsRead++;
   for(int icol=0;icol<NBcol;icol++) {
     mRet[icol] = 0.;
     if(!ColReadable[icol]) continue;
     fits_read_col_dbl(FitsPtr,icol+1,n+1,1,1,NulVal,&mRet[icol],&anynul,&sta);
     if(sta) printerror(sta);
   }
   return mRet;
 }

 // Gestion avec bufferisation
 if(n<LineDeb || n>LineFin) {
   NFitsRead++;
   long row1 = n+1;
   long row2 = row1+BuffLen-1; if(row2>NBline) row2 = NBline;
   long nrow = row2 - row1 + 1;
   LineDeb = n; LineFin = row2-1;
   for(int icol=0;icol<NBcol;icol++) {
     if(!ColReadable[icol]) continue;
     fits_read_col_dbl(FitsPtr,icol+1,row1,1,nrow,NulVal,Buffer[icol],&anynul,&sta);
     if(sta) printerror(sta);
   }
 }

 for(int icol=0;icol<NBcol;icol++)
   if(ColReadable[icol]) mRet[icol] = (Buffer[icol])[n-LineDeb];
     else mRet[icol] = 0.;

 return mRet;
}

r_8 FitsBTNtuIntf::GetCell(int n, int k) const
{
 if(n<0 || n>=NBline || k<0 || k>=NBcol) return 0.;
 r_8 * r = GetLineD(n);
 return r[k];
}

/*!
  Retourne une chaine de caracteres avec la declaration des noms de 
  variables. si "nomx!=NULL" , des instructions d'affectation
  a partir d'un tableau "nomx[i]" sont ajoutees (pour interface NTuple).
*/
string FitsBTNtuIntf::VarList_C(const char* nomx) const
{
 string rets;
 rets = "\ndouble";
 for(int icol=0;icol<NBcol;icol++) {
  rets += " " + ColName[icol];
  if(icol!=NBcol-1) rets += ","; else rets += ";\n";
 }
 if(!nomx) return rets;
 char buff[256];
 for(int icol=0;icol<NBcol;icol++) {
   sprintf(buff," = %s[%d];\n",nomx,icol);
   rets += ColName[icol] + buff;
 }
 return rets;
}

/////////////////////////////////////////////////
void FitsBTNtuIntf::printerror(int sta) const
{
 int stat = sta;
 fits_report_error(stdout,stat);
 return;
}

void FitsBTNtuIntf::Print(ostream& os,int lp) const
{
 os<<"FitsBTNtuIntf:Print ("<<BuffLen<<","<<NulVal<<")"
   <<" ncols="<<NBcol<<" nrows="<<NBline;
 if(lp>0) os<<" fitsrd="<<NFitsRead<<"*ncols";
 os<<"\n"<<FitsFN<<"["<<IHdu<<"]"<<endl;
 if(NBcol<=0 || lp<1) return;
 for(int icol=0;icol<NBcol;icol++) {
   os<<" "<<ColName[icol]<<"("<<ColReadable[icol]<<")";
   if(icol%4==3 || icol==NBcol-1) os<<endl;
 }
}
