#include <stdio.h>
#include "pigfd1.h"

 
/* --Methode-- */
PIGenFitDat::PIGenFitDat(GeneralFitData* gfd, bool ad)
: PIDrawer(), mGFD(gfd), mAdDO(ad), VarX(0), ErrX(false), ErrY(false)
{
SelectX(0);
SelectErrBar(false,false);
}

PIGenFitDat::~PIGenFitDat()
{
if(mAdDO && mGFD)  delete mGFD;
}

/* --Methode-- */
void  PIGenFitDat::SelectX(int varx)
{
VarX = -1;
if(mGFD == NULL) return;
if(varx<0 || varx>=mGFD->NVar()) return;
VarX = varx;
}

/* --Methode-- */
void  PIGenFitDat::SelectErrBar(bool erbx,bool erby)
{
ErrX = erbx; ErrY = erby;
if(mGFD == NULL) {ErrX = ErrY = false; return;}
if(!mGFD->HasXErrors()) ErrX = false;
}

/* --Methode-- */
void PIGenFitDat::UpdateLimits()
{
if(!mGFD) return;
if(mGFD->NData()<=0) return;
if(VarX<0) return;
double dx, dy;
double xmin=9.e19, xmax=-9.e19, ymin=9.e19, ymax=-9.e19;
mGFD->GetMinMax(10*VarX+2,xmin,xmax);
mGFD->GetMinMax(0,ymin, ymax);
if(xmax<=xmin) xmax = xmin+1.;
if(ymax<=ymin) ymax = ymin+1.;
dx = 0.02*(xmax-xmin);
dy = 0.02*(ymax-ymin);
SetLimits((float)xmin-dx,(float)xmax+dx,(float)ymin-dy,(float)ymax+dy);
SetAxesFlags(kBoxAxes | kExtTicks | kLabels);
}

/* --Methode-- */
void PIGenFitDat::Draw(PIGraphicUC* g, float xmin, float ymin, float xmax, float ymax)
{
if (!mGFD) return;
if(mGFD->NData()<=0) return;
if(VarX<0) return;
// On plotte les barre d'erreurs ligne demandee explicitement
if(mLAtt!=PI_NotDefLineAtt) SelectErrBar(true,true);
float xp,yp,er;
for (int i=0; i<mGFD->NData(); i++) {
  xp = mGFD->Absc(VarX,i);
  yp = mGFD->Val(i);
  if(xp<xmin || xp>xmax || yp<ymin || yp>ymax)  continue;
  if(ErrX) {
    er = mGFD->EAbsc(VarX,i);
    if(er>0.) g->DrawLine(xp-er,yp,xp+er,yp);
  }
  if(ErrY) {
    er = mGFD->EVal(i);
    if(er>0.) g->DrawLine(xp,yp-er,xp,yp+er);
  }
  g->DrawMarker(xp, yp); 
}
return;
}
