#include "toimanager.h"
#include "pexceptions.h"
#include "ctimer.h"
#include "map2toi.h"

////////////////////////////////////////////////////////////////////////
Map2TOI::Map2TOI(SphereHEALPix<r_8>& sph)
: mSph(sph)
{
}

Map2TOI::~Map2TOI()
{
}

////////////////////////////////////////////////////////////////////////
void Map2TOI::init() {
  cout << "Map2TOI::init" << endl;
  declareInput("AlphaIn");     // input  index 0
  declareInput("DeltaIn");     // input  index 1
  declareOutput("AlphaOut");   // output index 0
  declareOutput("DeltaOut");   // output index 1
  declareOutput("BoloOut");    // output index 2
}

////////////////////////////////////////////////////////////////////////
void Map2TOI::run() {

if(mSph.NbPixels()<1) {
  cout<<"Map2TOI::Map2TOI() Bad number of pixels in sphere "<<mSph.NbPixels()<<endl;
  throw ParmError("Map2TOI::Map2TOI() - Bad number of pixels in sphere");
}

long snb = getMinIn();
long sne = getMaxIn();
if(snb>sne) {
  cout<<"Map2TOI::run() - Bad sample interval"<<snb<<" , "<<sne<<endl;
  throw ParmError("Map2TOI::run() - Bad sample interval");
}
if(!checkInputTOIIndex(0) || !checkInputTOIIndex(1)) {
  cout<<"Map2TOI::run() - Input TOI (AlphaIn or DeltaIn) not connected! "<<endl;
  throw ParmError("Map2TOI::run() Output TOI (AlphaIn or DeltaIn) not connected!");
}
bool connected_AlphaOut = checkOutputTOIIndex(0);
bool connected_DeltaOut = checkOutputTOIIndex(1);
if(!checkOutputTOIIndex(2)) {
  cout<<"Map2TOI::run() - Output TOI (BoloOut) not connected! "<<endl;
  throw ParmError("Map2TOI::run() Output TOI (BoloOut) not connected!");
}

//---------------------------------------------------------
try {

for(int k=snb;k<=sne;k++) {

  int_8 flg = 0;
  //  double alpha = getData(0,k); // alpha entre [0,24[ en heures
  //  if(alpha<0. || alpha>=24.) flg=1;
  // On passe l'angle en longitude en degres - de [0,360[ deg
  double alpha = getData(0,k); // alpha entre [0,360[ en heures
  if(alpha<0. || alpha>=360.) flg=1;
  double delta = getData(1,k); // delta entre [-90,90] en degres
  if(delta<-90. || delta>90.) flg=1;
  double bolo = -99999.;

  if(!flg) {
    //    double phi   = alpha *M_PI/12.; // sphere phi entre [0,2*Pi] en radian
    double phi   = alpha *M_PI/180.; // sphere phi entre [0,2*Pi] en radian
    double teta  = (90.-delta) *M_PI/180.; // sphere teta entre [0,Pi] en radian
    bolo = mSph(teta,phi);
  }

  if(connected_AlphaOut) putData(0,k,alpha,0);
  if(connected_DeltaOut) putData(1,k,delta,0);
  putData(2,k,bolo,flg);
}

//---------------------------------------------------------
} catch (PException & exc) {
  cout<<"Map2TOI: Catched Exception "<<(string)typeid(exc).name()
      <<"\n .... Msg= "<<exc.Msg()<<endl;
}

return;                                                                            
}
