#ifndef XASTROPACK_H
#define XASTROPACK_H

#include "machdefs.h"
#include <string.h>
#include <string>

#ifdef __cplusplus
extern "C" {  /* extern "C" */
#endif
#include "XAstro/P_.h"
#include "XAstro/astro.h"
#ifdef __cplusplus
}             /* extern "C" */
#endif

enum TypAstroCoord {
  TypCoordUndef  =  (unsigned long)  (0),

  // Pour indiquer que les coordonnees sont en (heure=[0,24[,degre=[-90,90])
  TypCoordHD     =  (unsigned long)  (1 << 20),
  // Pour indiquer que les coordonnees sont en (degre=[0,360[,degre=[-90,90])
  TypCoordDD     =  (unsigned long)  (1 << 21),
  // Pour indiquer que les coordonnees sont en (radian=[0,2Pi[,radian=[-Pi/2,Pi/2])
  TypCoordRR     =  (unsigned long)  (1 << 22),

  // Coordonnees Equatoriales alpha,delta
  TypCoordEq     =  (unsigned long)  (1 << 0),
  TypCoordEqStd  =  (unsigned long) ((1 << 0) | (1 << 20)),
  // Coordonnees Galactiques gLong, gLat
  TypCoordGal    =  (unsigned long)  (1 << 1),
  TypCoordGalStd =  (unsigned long) ((1 << 1) | (1 << 21)),
  // Coordonnees Horizontales azimuth,altitude
  TypCoordHor    =  (unsigned long)  (1 << 2),
  TypCoordHorStd =  (unsigned long) ((1 << 2) | (1 << 21)),
  // Coordonnees Ecliptiques EclLong,EclLat
  TypCoordEcl    =  (unsigned long)  (1 << 3),
  TypCoordEclStd =  (unsigned long) ((1 << 3) | (1 << 21))
};

double TrueJDfrMJD(double mjd);
double MJDfrTrueJD(double jd);
double MJDfrDate(double dy,int mn,int yr);
void DatefrMJD(double mjd,double *dy,int *mn,int *yr);
double YearfrMJD(double mjd);
double MJDfrYear(double yr);
void YDfrMJD(double mjd,double *dy,int *yr);
double GSTfrUTC(double mjd0,double utc);
double UTCfrGST(double mjd0,double gst);
double GST0(double mjd0);
void Precess(double mjd1,double mjd2,double ra1,double dec1,double *ra2,double *dec2);
double AirmassfrAlt(double alt);
double HafrRaTS(double gst,double ra);
void HMSfrHdec(double hd,int *h,int *mn,double *s);
double HdecfrHMS(int h,int mn,double s);
string ToStringHMS(int h,int mn,double s);
string ToStringHdec(double hd);
void EqtoGal(double mjd,double ra,double dec,double *glng,double *glat);
void GaltoEq(double mjd,double glng,double glat,double *ra,double *dec);
void EqtoHor(double geolat,double ha,double dec,double *az,double *alt);
void HortoEq(double geolat,double az,double alt,double *ha,double *dec);
void EqtoEcl(double mjd,double ra,double dec,double *eclng,double *eclat);
void EcltoEq(double mjd,double eclng,double eclat,double *ra,double *dec);
void SunPos(double mjd,double *lsn,double *bsn);
void MoonPos(double mjd,double *lmn,double *bmn);
void PlanetPos(double mjd,int numplan,double *ecl,double *ecb,double *diamang);
void JupiterPos(double mjd,double *ecl,double *ecb,double *diamang);
void SaturnPos(double mjd,double *ecl,double *ecb,double *diamang);
int  CoordConvertToStd(TypAstroCoord typ,double& coord1,double& coord2);

#endif
