// This may look like C code, but it is really -*- C++ -*-
#ifndef TOI2MAP_H
#define TOI2MAP_H

#include "toiprocessor.h"
#include "spherehealpix.h"
#include "flagtoidef.h"
#include "xastropack.h"

//-- Un projecteur de TOI sur une sphere Healpix
// Lecture de 3 TOI coord1,coord2,boloMuV
// Sortie pas de TOI, une (2) sphere(s) Healpix
//
// Structure generale :
//                          |---->Sphere
//                          |
//                     -----------
//   toi Coord1In ---> |         |
//   toi Coord2In ---> | TOI2Map |
//   toi BoloIn   ---> |         |
//                     -----------
// Gestion du type de coordonnees :
// Coord1In,Coord2In : soit Equatoriales (Alpha,Delta)
//                     soit Galactiques  (GLong,GLat)
// Sortie sur une sphere en coordonnees Equatoriales ou Galactiques

class TOI2Map : public TOIProcessor {
public:
                 TOI2Map(SphereHEALPix<r_8>* sph,SphereHEALPix<r_8>* wsph=NULL);
  virtual	~TOI2Map();

  virtual void	init(void);
  virtual void	run(void);

  // Coordonnees donnees en entree et en sortie
  inline void SetEquinox(double actualyear=2000.)
              {mActualYear = actualyear;}
  inline void SetCoorIn(TypAstroCoord mfg=TypCoordGalStd)
              {mTypCoorIn = mfg;}
  inline void SetCoorOut(TypAstroCoord mfg=TypCoordGalStd)
              {mTypCoorOut = mfg;}

protected:
  SphereHEALPix<r_8>* mSph;
  SphereHEALPix<r_8>* mWSph;
  bool mWSphInternal;
  TypAstroCoord mTypCoorIn, mTypCoorOut;
  double mActualYear;
};

#endif
