// Creation d'une sphere de masque a partir d'une sphere de valeurs
//         cmv 13/6/01
// cremskfrsph -m 0.1 -v 1.,0. sph143k05_e.fits sphmskw.fits
// cremskfrsph -n -m -1.e-30. -M 1.e-30. -v 1.,0. sph143k05.fits sphmsk.fits
#include "machdefs.h"
#include <unistd.h>
#include <stdexcept>
#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>
#include "skymapinit.h"
#include "skymap.h"
#include "fitsspherehealpix.h" 

void usage();
void usage()
{
cout<<"cremskfrsph [-n -m min -M max -v valmsk,inimsk] sphval.fits sphmask.fits"<<endl
    <<" -m min : min value"<<endl
    <<" -M max : max value"<<endl
    <<"    condition for filling masque is : min<=sphere value<=max"<<endl
    <<"                                      (bounds are included)"<<endl
    <<" -n : negate the condition"<<endl
    <<" -v valmsk,inimsk:"<<endl
    <<"    valmsk: value to be put into mask if ok (def=1.)"<<endl
    <<"    inimsk: initialisation value for the mask (def=0.)"<<endl;
}


int main(int narg, char* arg[])
{
double vmin=-1.e30,vmax=1.e30,vmask=1.,vmaskini=0.;
bool tstmin=false,tstmax=false,negate=false;
int c;
while((c = getopt(narg,arg,"hnm:M:v:")) != -1) {
  switch (c) {
  case 'n' :
    negate = true;
    break;
  case 'm' :
    sscanf(optarg,"%lf",&vmin);
    tstmin = true;
    break;
  case 'M' :
    sscanf(optarg,"%lf",&vmax);
    tstmax = true;
    break;
  case 'v' :
    sscanf(optarg,"%lf,%lf",&vmask,&vmaskini);
    break;
  case 'h' :
  default:
    usage(); exit(1);
  }
}

if(optind+1>=narg) {usage(); exit(1);}
char * sphval = arg[optind];
char * sphmsk = arg[optind+1];

cout<<"Sphere values : "<<sphval<<endl
    <<"Sphere mask   : "<<sphmsk<<endl
    <<"  ...min "<<vmin<<"  max "<<vmax<<endl
    <<"  ...negate "<<negate<<endl
    <<"  ...mask set value "<<vmask<<endl
    <<"     mask init value "<<vmaskini<<endl;
cout<<"Condition : ";
if(negate) cout<<"!";
cout<<"( "<<vmin<<" <= V <= "<<vmax<<" ) bounds are included"<<endl;

// Lecture de la sphere Healpix des valeurs
SphereHEALPix<r_8> sph;        
FitsInFile sfits(sphval);
sfits >> sph;
cout<<"Opening Sphere HEALPix for testing values :"<<endl
    <<"          Type of map : "<<sph.TypeOfMap()<<endl
    <<"     Number of pixels : "<<sph.NbPixels()<<endl
    <<"                 Nlat : "<<sph.SizeIndex()<<endl;

// Ouverture de la sphere Healpix pour le masque
cout<<"Creating Mask Sphere"<<endl;
SphereHEALPix<r_8> sphm(sph,false);

// Filling Mask Sphere
cout<<"Filling Mask"<<endl;
uint_4 nmask = 0;
for(int_4 i=0;i<sph.NbPixels();i++) {
  sphm(i) = vmaskini;
  r_8 v = sph(i);
  bool intoint = true;
  if(tstmin && v<vmin) intoint=false;
  if(tstmax && v>vmax) intoint=false;
  //                    [vmin , vmax]
  // intoint :   false  [    true   ]  false  (si tstmin && tstmax)
  // intoint :   false  [    true             (si tstmin && !tstmax)
  // intoint :               true   ]  false  (si !tstmin && tstmax)
  if(negate && intoint) continue;
  else if(!negate && !intoint) continue;
  sphm(i) = vmask;
  nmask++;
}
cout<<"    .... Number of values set in mask   : "<<nmask<<endl;
cout<<"    .... Fraction of values set in mask : "
    <<(r_8)nmask/sph.NbPixels()*100.<<" %"<<endl;

// Ecriture de la sphere Healpix sur fits
{
string dum = "rm -f "; dum += sphmsk; system(dum.c_str());
FitsOutFile swfits(sphmsk);
cout<<"Writing Mask Sphere Fits file"<<endl;
swfits<<sphm;
}

exit(0);
}
