#include "toimanager.h"
#include "nooppr.h"
// ----------------------------------------------------------------------
//   Classe SimpleFourierFilter : Filtre simple ds le domaine de Fourier
// ----------------------------------------------------------------------

NoOpProcessor::NoOpProcessor(int wsz)
{
  wsize = wsz;
  totnscount = 0;
}



void NoOpProcessor::PrintStatus(ostream & os)
{
  os << "\n ------------------------------------------------------ \n" 
     << " NoOpProcessor::PrintStatus() - WindowSize=" 
     << WSize() << endl; 
  os << " Total number of processed samples= " << ProcessedSampleCount()
     << endl;
  TOIProcessor::PrintStatus(os);
  os << " ------------------------------------------------------ " << endl;
}

void NoOpProcessor::init() {
  cout << "NoOpProcessor::init" << endl;
  declareInput("in");
  declareInput("in2");
  declareOutput("out");
  declareOutput("out2");
  name = "NoOpProcessor";
  //  upExtra = 1;
}


void NoOpProcessor::run() {
  //  TOIManager* mgr = TOIManager::getManager();
  int snb = getMinIn();
  int sne = getMaxIn();


  if (!checkInputTOIIndex(0)) {
    cerr << " NoOpProcessor::run() - Input TOI (in) not connected! "
	 << endl;
    throw ParmError("NoOpProcessor::run() Input TOI (in) not connected!");
  }
  bool fgin2 = checkInputTOIIndex(1);

  bool fgout = checkOutputTOIIndex(0);
  bool fgout2 = checkOutputTOIIndex(1);

  if (fgout2 && !fgin2) {
    cerr << " NoOpProcessor::run() - out2 connected without in2!"
	 << endl;
    throw ParmError("NoOpProcessor::run() out2 connected without in2!");
  }
  cout << " NoOpProcessor::run() SNRange=" << snb << " - " << sne << endl; 
  
  double * vin = NULL;
  double * vin2 = NULL;
  uint_8 * vfg = NULL;
  uint_8 * vfg2 = NULL;
  try {
    // Le debut
    int k,i,klast;
    klast = snb-1;
    int totnbblock = 0;
    
    if (wsize > 1) {
      vin = new double[wsize];
      vfg = new uint_8[wsize];
      if (fgin2) {
	vin2 = new double[wsize];
	vfg2 = new uint_8[wsize];
      }
    
      // Boucle sur les sampleNum
      // 1er partie, on traite par paquets de wsize
      for(k=snb;k<=sne-wsize+1;k+=wsize) {
	for(i=0; i<wsize; i++) { 
	  getData(0, k+i, vin[i], vfg[i]);
	  if (fgin2)
	    getData(1, k+i, vin2[i], vfg2[i]);
	}
	totnbblock++;
	for(i=0; i<wsize; i++) {
	  if (fgout) 
	    putData(0,k+i,vin[i],vfg[i]);
	  if (fgout2)  
	    putData(1, k+i, vin2[i], vfg2[i]);
	}
	klast+=wsize;
	totnscount+=wsize;
      }
    }

    // 2eme partie, on traite la fin du bloc d'echantillons si necessaire
    double inval;
    uint_8 inflg;
    if (klast < sne) 
      for(k=klast+1; k<=sne; k++) {
	getData(0, k, inval, inflg);
	if (fgout) putData(0, k, inval, inflg);
	if (fgin2) { 
	  getData(1, k, inval, inflg);
	  if (fgout2) 
	    putData(1, k, inval, inflg);
	}
	totnscount++;
      }

    totnbblock++;

    cout << " NoOpProcessor::run() - End of processing " 
	 << " TotNbBlocks= " << totnbblock << endl;
  }  // Bloc try 

  catch (PException & exc) {
    cerr << "NoOpProcessor: Catched Exception " << (string)typeid(exc).name()
         << "\n .... Msg= " << exc.Msg() << endl;
  }

  if (vin) delete[] vin; 
  if (vfg) delete[] vfg;  
  if (vin2) delete[] vin2; 
  if (vfg2) delete[] vfg2;  

}
