/*   Test de GenWindowTOIProcessor (generic processor with window)
----------------   Exemple d'appel  ---------------------
csh> time ./tgenw -intoi bolo -start 1 -end 50000 -wgen 16,1,64 -wlcr 0,0,0 \
           -dbg 0 toto.fits xx.fits
*/

#include "machdefs.h"
#include <math.h>
#include "array.h"
#include <unistd.h>
#include <stdexcept>
#include "toi.h"
#include "toiprocessor.h"
#include "fitstoirdr.h"
#include "fitstoiwtr.h"
#include "toimanager.h"
#include "genwproc.h"
#include "toiseqbuff.h"
#include "timing.h"
#include "sambainit.h"

// ----- Classe de test heritant de GenWindowTOIProcessor -----
class TGenWProc : public GenWindowTOIProcessor {
public:
  TGenWProc(int ntoiout, int wsz, int step, int wt);
  virtual void UserInit(int_8 kstart);
  virtual void UserProc(int_8 ks);
  virtual void UserEnd(int_8 kend);
protected:
  int_8 SNRunning;
};

TGenWProc::TGenWProc(int ntoiout,int wsz, int step, int wt)
  : GenWindowTOIProcessor(1,ntoiout,wsz,step,wt)
{
  SNRunning = 1;
}
void TGenWProc::UserInit(int_8 kstart)
{
  cout << "TGenWProc::UserInit(" << kstart << ")" << endl;
}
void TGenWProc::UserEnd(int_8 kend)
{
  cout << "TGenWProc::UserEnd(" << kend << ")" << endl;
}

void TGenWProc::UserProc(int_8 ks)
{
  if( ks==StartSampleNum() || ks>=EndSampleNum()-1 || ks%1000==0 )
    cout<<"TGenWProc::UserProc("<<ks<<") CenterSample="<<GetWCenterSample()<<endl;

  // Test pour fichier cmv toto.fits (sn=100000+i, bolo=i)
  r_8 * datatest = GetWDataPointer();
  for(int_4 i=0;i<WSize;i++) {
    int_8 k=ks-WSize/2+i;
    if(k<SNbegin || k>SNend) continue;
    if(datatest[i]!=k-100000) {cout<<"PROBLEME ks="<<ks<<endl; break;}
  }

  if(!NbOutput) return;

  if(GetWStep()==1) {
    // Cas ou on a un step de 1
    r_8 data;
    uint_8 flag;
    GetData(ks,data,flag);
    PutWData(ks,data,flag);

  } else if(GetWStep()<GetWSize()) {
    // Cas ou on a un step plus petit que la fenetre:
    // on peut donc reconstituer le TOI original en sortie
    // (ca marche aussi pour WStep==1 mais test different)
    // ATTENTION: l'ordre d'ecriture depend de la taille relative
    // de WSize et WStep.
    // Il faut en plus faire attention au premier echantillon et au dernier
    // Visiblement il faut ecrire autant de donnees en sortie que lues en entree (??)
    // ===> Conduit a une logique d'une simplicite extreme:
    // ATTENTION: dans certains cas ca bloque car il peut arriver que
    // SNend ne soit jamais atteint selon les valeurs de WSize/WStep !
    // et on ne peut donc pas ecrire autant de valeurs en sortie que lues en entree
    TVector<r_8> data;
    TVector<uint_8> flag;
    int_4 ideb,ifin,isndeb;
    if(GetWStep()<=GetWSize()/2+1) {
      //  ------|------
      //      ------|------
      //        :   :
      //        WStep
      //        :  :
      //        d..f
      ideb = GetWCenterIndex();
      isndeb = GetWCenterSample();
      ifin = ideb + GetWStep()-1;
    } else {
      //  ------|------
      //             ------|------
      //        :          :
      //            WStep
      //  :         :
      //  d.........f
      ifin = GetWSize()-1;
      ideb = ifin - GetWStep()+1;
      isndeb = GetWStartSample() + ideb;
    }
    if(isndeb<StartSampleNum()) {
      cout<<"........ ideb="<<ideb<<" isndeb="<<isndeb<<endl;
      ideb = StartSampleNum() - GetWStartSample();
      isndeb = StartSampleNum();
    }
    if(GetWStartSample()+ifin>EndSampleNum()) {
      cout<<"........ ifin="<<ifin<<endl;
      ifin = EndSampleNum() - GetWStartSample();
    }
    cout<<".... ideb="<<ideb<<" ifin="<<ifin<<" isndeb="<<isndeb<<endl;
    data = GetWData()(Range(ideb,ifin));
    flag = GetWFlag()(Range(ideb,ifin));
    PutWData(isndeb,data,flag);
  } else {
    // Cas ou on ne peut reproduire le TOI initial
    // On renumerote les samples
    // ATTENTION: faut en mettre autant en sortie que lu en entree (???)
    // ATTENTION: dans certains cas ca bloque car il peut arriver que
    // SNend ne soit jamais atteint selon les valeurs de WSize/WStep !
    // et on ne peut donc pas ecrire autant de valeurs en sortie que lues en entree
    // CA NE MARCHE PAS DANS CE CAS
    TVector<r_8> data;
    TVector<uint_8> flag;
    int_4 ideb=0, ifin=GetWSize()-1;
    int_8 ilen = EndSampleNum() - StartSampleNum() + 1;
    if(GetWStartSample()+ideb<StartSampleNum()) {
      cout<<"........ ideb="<<ideb<<endl;
      ideb = StartSampleNum() - GetWStartSample();
    }
    if(GetWStartSample()+ifin>EndSampleNum()) {
      cout<<"........ ifin="<<ifin<<endl;
      ifin = EndSampleNum() - GetWStartSample();
    }
    data = GetWData()(Range(ideb,ifin));
    flag = GetWFlag()(Range(ideb,ifin));
    cout<<".... ideb="<<ideb<<" ifin="<<ifin<<" SNRunning="<<SNRunning<<endl;
    PutWData(SNRunning,data,flag);
    SNRunning += ifin-ideb+1;
    if(SNRunning<=ilen && GetWStep()-GetWSize()>0) {
      for(int_4 i=0;i<GetWStep()-GetWSize() && SNRunning<=ilen;i++)
        {PutWData(SNRunning,0.,0); SNRunning++;}
      // De toute facon impossible a faire puisque
      // ce putwdata efface le vecteur du putwdata precedent
    }
    cout<<".................... SNRunning="<<SNRunning<<endl;
  }
  // Oh que voila une logique simple et utilisable par tout un chacun !!!
}

void Usage(bool fgerr)
{
  cout << endl;
  if (fgerr) {
    cout << " tgenw : Argument Error ! tgenw -h for usage " << endl; 
    exit(1);
  }
  else {
    cout << "\n Usage : tgenw [-prt] [-dbg dbg] [-start snb] [-end sne] [-intoi name] \n" 
	 << "         [-wtoi sz] [-wgen sz,step,szt] inFitsName outFitsName \n"
	 << "   -prt : sets TOISeqBuffered debug level to 1 \n"
	 << "   -dbg : debug level for GenWProc \n"
	 << "   -start snb : sets the start sample num \n"
	 << "   -end sne : sets the end sample num \n"
	 << "   -intoi toiName : select input TOI name (def boloMuV_27)\n"
	 << "   -wtoi sz : sets TOISeqBuff buffer size (def= 8192)\n"
	 << "   -wgen sz,step,szt : sets GenWProc window size, step total size \n"
	 << "   -wlcr szl,szc,szr : sets LCR Window \n"
	 << endl;
    exit(0);
  }
}

int main(int narg, char** arg) {

  if ((narg > 1) && (strcmp(arg[1],"-h") == 0) ) Usage(false);

  cout << "tgenw starting - Decoding arguments " << " narg=" << narg << endl;

  bool fgdbg = false;
  bool fgsetstart = false;
  int dbglevel = 0;
  int wtoi = 8192;
  int wgen = 16;
  int stepgen = 1;
  int wgl = 0, wgc = 0, wgr = 0;
  int wtotgen = 0;
  int istart = 0;
  int iend = 0;
  string infile;
  string outfile = "";
  string outppfname;
  string intoi = "boloMuV_27";

  if (narg < 2) Usage(true);
  int ko=1;
  // decoding arguments 
  for(int ia=1; ia<narg; ia++) {
    if (strcmp(arg[ia],"-start") == 0) {
      if (ia == narg-1) Usage(true);  // -start est suivi d'un argument 
      istart = atoi(arg[ia+1]); ia++;
      fgsetstart = true;
    }    
    else if (strcmp(arg[ia],"-end") == 0) {
      if (ia == narg-1) Usage(true);  
      iend = atoi(arg[ia+1]); ia++;
    }    
    else if (strcmp(arg[ia],"-wtoi") == 0) {
      if (ia == narg-1) Usage(true);  
      wtoi = atoi(arg[ia+1]); ia++;
    }    
    else if (strcmp(arg[ia],"-wgen") == 0) {
      if (ia == narg-1) Usage(true);  
      sscanf(arg[ia+1],"%d,%d,%d",&wgen,&stepgen,&wtotgen); ia++;
    }    
    else if (strcmp(arg[ia],"-wlcr") == 0) {
      if (ia == narg-1) Usage(true);  
      sscanf(arg[ia+1],"%d,%d,%d",&wgl,&wgc,&wgr); ia++;
    }    
    else if (strcmp(arg[ia],"-intoi") == 0) {
      if (ia == narg-1) Usage(true);  
      intoi = arg[ia+1]; ia++;
    }    
    else if (strcmp(arg[ia],"-dbg") == 0) {
      if (ia == narg-1) Usage(true);  
      sscanf(arg[ia+1],"%d",&dbglevel); ia++;
    }    
    else if (strcmp(arg[ia],"-prt") == 0)  fgdbg = true;

    else { ko = ia; break; }  // Debut des noms
  }

  if (iend < istart) iend = istart+wtoi*10;
  if ((narg-ko) < 1)  Usage(true); 
  infile = arg[ko];
  if(ko+1<narg) outfile = arg[ko+1];
  // outppfname = arg[ko+2];

  cout << " Initializing SOPHYA ... " << endl;
  SophyaInit();
  InitTim();

  cout << ">> tgenw: Infile= " << infile << " outFile=" 
       << outfile << endl; 
  cout << ">>> Window Size WTOI= " << wtoi << " WGenSz= " << wgen
       << " StepGen=" << stepgen << " WTot=" << wtotgen
       << " Wglcr=" << wgl << "," << wgc <<  "," << wgr << endl;
  cout << ">>>> InTOIName= " << intoi 
       << "  iStart= " << istart << " iEnd= " << iend << endl;

  try {
    TOIManager* mgr = TOIManager::getManager();
  
    //  mgr->setRequestedSample(11680920,11710584);
    //  mgr->setRequestedSample(104121000, 104946120);
    if (fgsetstart)
      mgr->setRequestedSample(istart, iend);
  
    FITSTOIReader r(infile); 
    cout << "reader created" << endl;

    int ntoiout=0;
    FITSTOIWriter* w=NULL;
    if(outfile.size()>0) {
      ntoiout=1;
      w = new FITSTOIWriter(outfile);
      w->setOutFlags(true);
      cout << "fits writer created" << endl;
    }

    TOISeqBuffered * toiin = new TOISeqBuffered("f2in", wtoi);
    if (fgdbg) toiin->setDebugLevel(1);

    TOISeqBuffered * toiout = NULL;
    if(w) {
      toiout = new TOISeqBuffered("genout", wtoi);
      if (fgdbg) toiout->setDebugLevel(1);
    }

    TGenWProc tgenp(ntoiout, wgen, stepgen, wtotgen);
    tgenp.SetWSizeLCR(wgl,wgc,wgr);
    tgenp.SetDbgLevel(dbglevel);

    cout << " Connecting to FitsReader ... " << endl;
    r.addOutput(intoi, toiin);

    if(w && toiout) {
      cout << " Connecting to FitsWriter ... " << endl;
      w->addInput("genout",toiout);
    }

    cout << " Connecting  TGenWProc ... " << endl;
    tgenp.addInput("in0",toiin);
    if(toiout) tgenp.addOutput("out0",toiout);
    tgenp.PrintStatus(cout,1);

    PrtTim("starting threads");
    r.start();
    tgenp.start();
    if(w) w->start();

    /*       
    for(int jj=0; jj<3; jj++) {
      cout << *toiin; 
      if(toiout) cout << *toiout; 
      sleep(1);
    }
    */

    mgr->joinAll();
    PrtTim("End threads");

    //    cout << " ------ FITSReaderTOI::PrintStatus() : ----- " << endl;
    //    r.PrintStatus(cout);  
    //    cout << "----- FITSWriterTOI::PrintStatus() : ----- " << endl;
    //    w->PrintStatus(cout);  

    cout << " ------ toiin, toiout Status information ------- " << endl;
    cout << *toiin; 
    if(toiout) cout << *toiout;
    tgenp.PrintStatus(cout);

    // Fermeture du fitswriter
    if(w) delete w;;

  }
  catch (PThrowable & exc) {
    cerr << "\n tgenw: Catched Exception \n" << (string)typeid(exc).name() 
	 << " - Msg= " << exc.Msg() << endl;
  }
  catch (const std::exception & sex) {
    cerr << "\n tgenw: Catched std::exception \n" 
	 << (string)typeid(sex).name() << endl; 
  }
  catch (...) {
    cerr << "\n tgenw: some other exception was caught ! " << endl;
  }

  return(0);
}
