// Creation d'une sphere de masquee a partir d'une sphere de masques
//         cmv 15/6/01
#include "machdefs.h"
#include <unistd.h>
#include <stdexcept>
#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>
#include "skymapinit.h"
#include "skymap.h"
#include "fitsspherehealpix.h" 

void usage();
void usage()
{
cout<<"msksphere [-m min -M max -v valmsk]"<<endl
    <<"          sphval.fits sphmask.fits sphout.fits"<<endl
    <<" -m min : min value"<<endl
    <<" -M max : max value"<<endl
    <<"        condition for masking is :"<<endl
    <<"           mask_sphere_value <= min"<<endl
    <<"        OR"<<endl
    <<"           mask_sphere_value >= max"<<endl
    <<"        (bounds are included)"<<endl
    <<"        Default is mask_sphere_value <=0. (no -m and -M)"<<endl
    <<" -v valmsk : set value for masked pixels (def=0.)"<<endl;
}

int main(int narg, char* arg[])
{
double vmask=0.,vmin=-1.e30,vmax=1.e30;
bool tstmin=false,tstmax=false;
int c;
while((c = getopt(narg,arg,"hm:M:v:")) != -1) {
  switch (c) {
  case 'm' :
    sscanf(optarg,"%lf",&vmin);
    tstmin = true;
    break;
  case 'M' :
    sscanf(optarg,"%lf",&vmax);
    tstmax = true;
    break;
  case 'v' :
    sscanf(optarg,"%lf",&vmask);
    break;
  case 'h' :
  default:
    usage(); exit(1);
  }
}

if(optind+2>=narg) {usage(); exit(1);}
char * sphval = arg[optind];
char * sphmsk = arg[optind+1];
char * sphout = arg[optind+2];

cout<<"Sphere values : "<<sphval<<endl
    <<"Sphere mask   : "<<sphmsk<<endl
    <<"Sphere out    : "<<sphout<<endl
    <<"  ...min("<<tstmin<<") "<<vmin<<"  max("<<tstmax<<") "<<vmax<<endl
    <<"  ...mask set value "<<vmask<<endl
    <<"Condition for masking pixel is : "
    <<"( Vmsk <= "<<vmin<<" OR Vmsk >= "<<vmax<<" ) bounds are included"<<endl;

// Lecture de la sphere Healpix des valeurs
SphereHEALPix<r_8> sph;        
{FitsInFile sfits(sphval); sfits >> sph;}
cout<<"Opening Sphere HEALPix for testing values :"<<endl
    <<"          Type of map : "<<sph.TypeOfMap()<<endl
    <<"     Number of pixels : "<<sph.NbPixels()<<endl
    <<"                 Nlat : "<<sph.SizeIndex()<<endl;

// Lecture de la sphere Healpix des masques
SphereHEALPix<r_8> msph;        
{FitsInFile sfits(sphmsk); sfits >> msph;}
cout<<"Opening Sphere HEALPix for mask :"<<endl
    <<"          Type of map : "<<msph.TypeOfMap()<<endl
    <<"     Number of pixels : "<<msph.NbPixels()<<endl
    <<"                 Nlat : "<<msph.SizeIndex()<<endl;
if(msph.SizeIndex()!=sph.SizeIndex()) {
  cout<<"Sphere of values and sphere of mask must have same NLat"<<endl;
  exit(1);
}

// Filling Mask Sphere
cout<<"Testing For Masked Pixels"<<endl;
uint_4 nmask = 0;
for(int_4 i=0;i<sph.NbPixels();i++) {
  r_8 v = msph(i);
  bool masked=false;
  if(tstmin && v<=vmin) {sph(i) = vmask; masked = true;}
  if(tstmax && v>=vmax) {sph(i) = vmask; masked = true;}
  if(!tstmin && !tstmax && v<=0.)
                        {sph(i) = vmask; masked = true;}
  if(masked) nmask++;
}
cout<<"    .... Number of values masked   : "<<nmask<<endl;
cout<<"    .... Fraction of values masked : "
    <<(r_8)nmask/sph.NbPixels()*100.<<" %"<<endl;

// Ecriture de la sphere Healpix sur fits
{
string dum = "rm -f "; dum += sphout; system(dum.c_str());
FitsOutFile sfits(sphout);
cout<<"Writing Output Masked Sphere Fits file"<<endl;
sfits<<sph;
}

exit(0);
}
