// This may look like C code, but it is really -*- C++ -*-
#ifndef TOI2MAP_H
#define TOI2MAP_H

#include "toiprocessor.h"
#include "toiprocessor.h"
#include "spherehealpix.h"
#include "flagtoidef.h"
#include "xastropack.h"

//-- Un projecteur de TOI sur une sphere Healpix
// Lecture de 3 TOI coord1,coord2,boloMuV
// Sortie pas de TOI, une (2) sphere(s) Healpix
//
// Structure generale :
//                          |---->Sphere
//                          |
//                     -----------
//   toi Coord1In ---> |         |
//   toi Coord2In ---> | TOI2Map |
//   toi BoloIn   ---> |         |
//                     -----------
// Gestion du type de coordonnees :
// Coord1In,Coord2In : soit Equatoriales (Alpha,Delta)
//                     soit Galactiques  (GLong,GLat)
// Sortie sur une sphere en coordonnees Equatoriales ou Galactiques
// Si les CoordIn et les CoordOut sont equatoriales -> meme equinoxe!

class TOI2Map : public TOIProcessor {
public:
                 TOI2Map(SphereHEALPix<r_8>* sph,SphereHEALPix<r_8>* wsph=NULL);
  virtual	~TOI2Map();

  virtual void	init(void);
  virtual void	run(void);

  // Coordonnees donnees en entree et en sortie
  inline void SetEquinox(double actualyear=2000.)
              {mActualYear = actualyear;}
  inline void SetCoorIn(TypAstroCoord mfg=TypCoordGalStd)
              {mTypCoorIn = mfg;}
  inline void SetCoorOut(TypAstroCoord mfg=TypCoordGalStd)
              {mTypCoorOut = mfg;}
  // Test on flag value ? if yes, BAD sample have flag matching mBadFlag
  inline void SetTestFlag(bool tflg=false, uint_8 badflg=0)
              {mTFlag = tflg; mBadFlag = badflg;}
  // Test on min value ? if yes, GOOD sample have value >= mValMin
  // Test on max value ? if yes, GOOD sample have value <= mValMax
  // Good values are (mValMin <= sample value <= mValMax)
  //                      bounds are included
  inline void SetTestMin(bool tmin=false, r_8 vmin=-1.e30)
              {mTMin = tmin; mValMin = vmin;}
  inline void SetTestMax(bool tmax=false, r_8 vmax=+1.e30)
              {mTMax = tmax; mValMax = vmax;}
  // Print
  void Print(ostream & os);

protected:
  SphereHEALPix<r_8>* mSph;
  SphereHEALPix<r_8>* mWSph;
  bool mWSphInternal;

  TypAstroCoord mTypCoorIn, mTypCoorOut;
  double mActualYear;

  bool mTFlag,mTMin,mTMax;
  uint_8 mBadFlag;
  r_8 mValMin,mValMax;
};

#endif
