//  Classe de base pour les conteneurs de PIWdg pour
//  programmes graphiques interactives
//
//                  E.Aubourg , R. Ansari  96 - 98
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#include "picontainergen.h"

//++
// Class	PIContainer
// Lib		PI
// include	picontainergen.h
//
//	Classe conteneur grant un ensemble d'objets "PIWdg". Cette classe 
//	organise la hirarchie des objets "PIWdg" et donc aussi des "PIMsgHandler",
//	contrle la gomtrie des objets "PIWdg" contenus, ainsi que leur 
//	visibilit et activit. La classe "PIContainer" est une des 
//	classes de PI qui ont une implementation dpendante du systeme utilis
//	(Mac, XWindow, ...). La classe "PIContainerGen" est la classe qui
//	dfinit l'interface, et ne pas doit tre instancie directement
//	(Mthodes virtuelles pures). Les objets instancis sont de la 
//	classes "PIContainer" et le fichier entte correspondant est "PICONT_H"
//	dfini dans "pisysdep.h"
//--
//++
// Links	Parents
// PIWdg
//--
//++
// Titre	Constructeur
//--
//++
// PIContainer(PIContainerGen *par, char *nom, int sx, int sy, int px, int py)
//	Cration d'un objet "PIContainer" dans le conteneur parent "par", de
//	taille "sx,sy", se trouvant  la position "px,py" avec le nom "nom".
//	Tous les widgets fils sont dtruits (delete) par le destructeur
//	(voir "SetAutoDelChilds()")
// long kind()
//	Renvoie le type de la classe de l'objet ("=PIContainerGen::ClassId") pour cette classe.
//--
//++
// Titre	Mthodes
//--
//++
// void Show()
//	Rend l'objet visible  l'cran. Tous les objets "PIWdg" contenus et qui sont dans 
//	l'tat actif sont visibles.
// void Hide()
//	Rend l'objet et tous les objets contenus invisibles.
// void  PSPrint(PSFile *psf, int ofx=0, int ofy=0)
//	Appelle la mthode "PSPrint()" pour tous les objets contenus.
// void  SetAutoDelChilds(bool ad = false)
//	Contrle le comportement de l'objet conteneur vis  vis des objets
//	contenus lors de la destruction. si "ad=true", les objets contenus 
//	sont dtruits lors de l'appel du destructeur de l'objet conteneur. 
//--

#define NCHALGRP 8

/* --Methode-- */
PIContainerGen::PIContainerGen(PIContainerGen *par, char *nom, 
                               int sx, int sy, int px, int py)
: PIWdg(par, nom, sx, sy, px, py)  
{
mNCh = 0;
mACSup = false;   // Suppression automatique des widgets fils au delete
mPaSup = false;
mChilds = new (PIWdg* [NCHALGRP]);
mMxCh = NCHALGRP;
stvis = false;
stfcr = false;
}


/* --Methode-- */
PIContainerGen::~PIContainerGen()
{
mPaSup = true;   // Pour prevenir ChildDel()
if (mACSup)
  for(int i=0; i<mNCh; i++)  delete mChilds[i];
delete[] mChilds;
}

/* --Methode-- */
void PIContainerGen::PSPrint(PSFile *psf, int ofx, int ofy)
{
int i;
if (!psf)  return;
if (!Visible())  return;
for(i=0; i<mNCh; i++)  mChilds[i]->PSPrint(psf, ofx+XPos(), ofy+YPos()); 
return;
}

/* --Methode-- */
void PIContainerGen::Show()
{
stvis = true;
Manage();
return;
}

/* --Methode-- */
void PIContainerGen::Hide()
{
stvis = false;
UnManage();
return;
}

/* --Methode-- */
bool PIContainerGen::Visible()
{
if (Parent())  return(stvis && Parent()->Visible());
else return(stvis && IsVisible());
}

/* --Methode-- */
void PIContainerGen::ChildAdd(PIWdg* child)
{
if (child == NULL)  return;
if (mNCh == mMxCh)
  {
  PIWdg ** och = mChilds;
  mChilds = new (PIWdg * [mMxCh+NCHALGRP]);
  for(int i=0; i<mNCh; i++)  mChilds[i] = och[i];
  delete[] och;
  mMxCh += NCHALGRP;
  }  
mChilds[mNCh] = child;   mNCh++; 
// Reza 13/10/98 : il faut que child->FinishCreate() 
// soit appele pour les PIWdg ajoute quand le  container est deja affiche et son FinishCreate() appele
if (stfcr)  child->FinishCreate(); 
return;
}

/* --Methode-- */
void PIContainerGen::ChildDel(PIWdg* child)
{
if (mPaSup) return;  // Ne rien faire si delete initie par Container-parent
if ((child == NULL) || (mNCh < 1))  return;
for(int i=0; i<mNCh; i++)  
  if (mChilds[i] == child)
    {
    mNCh--;
    mChilds[i] = mChilds[mNCh];
    break;
    }
return;
}

/* --Methode-- */
int PIContainerGen::NbChilds()
{
return(mNCh);
}

/* --Methode-- */
PIWdg* PIContainerGen::GetChild(int n)
{
if ( (n < 0) || (n >= mNCh))  return(NULL);
return ((PIWdg*)mChilds[n]);
}

/* --Methode-- */
void PIContainerGen::SetAutoDelChilds(bool ad)
{
mACSup = ad;
return;
}

/* --Methode-- */
void PIContainerGen::FinishCreate()
{
if (stfcr)  return;
int k;
for(k=0; k<mNCh; k++)  mChilds[k]->FinishCreate();
stfcr = true;
}

