#ifndef PICONTAINERBASE_SEEN
#define PICONTAINERBASE_SEEN

#include "pisysdep.h"

#include PIWDG_H


class PIContainerGen : public PIWdg 
{
public:
  enum {ClassId = 1500};

               PIContainerGen(PIContainerGen *par, char *nom, 
                              int sx=10, int sy=10, int px=0, int py=0);
  virtual      ~PIContainerGen();

  virtual long         kind() {return ClassId; }

  virtual void         PSPrint(PSFile *psf, int ofx=0, int ofy=0);

  virtual void         Show();
  virtual void         Hide();
  virtual bool         Visible();

  virtual void         ChildAdd(PIWdg* child);
  virtual void         ChildDel(PIWdg* child);
  virtual int          NbChilds();
  virtual PIWdg*       GetChild(int n);

          void         SetAutoDelChilds(bool ad = false);
  virtual void	       FinishCreate(); // appelle FinishCreate() pour les descendants 

protected:
  bool                 stvis, stfcr;  // Statut visible ou pas, FinishCreate appele ou pas
  PIWdg                ** mChilds;
  int                  mNCh, mMxCh;
  bool                 mPaSup, mACSup;
};

#endif
