// This may look like C code, but it is really -*- C++ -*-

#ifndef GENWPROC_H
#define GENWPROC_H

#include "toiprocessor.h"
#include "tvector.h"

#include <vector>


class GenWindowTOIProcessor : public TOIProcessor {
public:
  GenWindowTOIProcessor(int_4 nbinput,int_4 nboutput,int_4 wsz, int_4 wstep=1, int_4 wsztot=-1);
  virtual ~GenWindowTOIProcessor();

  inline int_4 GetWSize() const { return WSize; }
  inline int_4 GetWStep() const { return WStep; }
  inline int_4 ProcessedSampleCount() const { return TotNsCount; }

  // DbgLevel = 0 : No debug
  // DbgLevel = 1 : Print fenetre WSize
  // DbgLevel = 2 : 1 + Print logique remplissage/decalage
  // DbgLevel = 3 : 2 + Print fenetre WSizeTot et WSizeL,C,R
  inline void SetDbgLevel(int_2 lp=0) {DbgLevel = (lp>0) ? lp : 0;}

  void SetWSizeLCR(int_4 wszl=0,int_4 wszc=0,int_4 wszr=0);
  inline int_4 GetWSize(char cw)
               {if     (cw=='l') return WSizeLeft;
                else if(cw=='c') return WSizeCenter;
                else if(cw=='r') return WSizeRight;
                                 return WSize;}

  inline int_8 GetWStartSample()  {return StartSample;}
  inline int_8 GetWCenterSample() {return StartSample + WSize/2;}
  inline int_8 GetWCenterIndex()  {return WSize/2;}
  inline int_8 StartSampleNum()   {return SNbegin;}
  inline int_8 EndSampleNum()     {return SNend;}

  inline void SetDefaultValue(r_8 r8dval=0., int_8 i8dval=0)
                      {R8DefVal = r8dval; I8DefVal = i8dval;}

  TVector<r_8> GetWData(int_4 numtoi=0);
  TVector<uint_8> GetWFlag(int_4 numtoi=0);
  r_8 * GetWDataPointer(int_4 numtoi=0);
  uint_8 * GetWFlagPointer(int_4 numtoi=0);
  void GetData(int_4 numtoi, int_8 numsample, r_8 & data, uint_8 & flag);
  inline void GetData(int_8 numsample, r_8 & data, uint_8 & flag)
                      { GetData(0, numsample, data, flag); }

  TVector<r_8> GetWData(char cw,int_4 numtoi=0);
  TVector<uint_8> GetWFlag(char cw,int_4 numtoi=0);
  r_8   * GetWDataPointer(char cw,int_4 numtoi,int_4& n);
  uint_8 * GetWFlagPointer(char cw,int_4 numtoi,int_4& n);
  inline   r_8 * GetWDataPointer(char cw,int_4& n)
                 {return GetWDataPointer(cw,0,n);}
  inline uint_8 * GetWFlagPointer(char cw,int_4& n)
                 {return GetWFlagPointer(cw,0,n);}

  void PutWData(int_4 numtoi,int_8 numsample,TVector<r_8>& data,TVector<uint_8>& flag);
  void PutWData(int_4 numtoi,int_8 numsample,r_8 data,uint_8 flag);
  inline void PutWData(int_8 numsample,TVector<r_8>& data,TVector<uint_8>& flag)
                      {PutWData(0,numsample,data,flag);}
  inline void PutWData(int_8 numsample,r_8 data,uint_8 flag)
                      {PutWData(0,numsample,data,flag);}

  virtual void PrintStatus(ostream & os);

  virtual void UserInit(int_8 kstart);
  virtual void UserProc(int_8 ks);
  virtual void UserEnd(int_8 kend);

  virtual void	init();  
  virtual void	run();

protected:
  void Remplissage(int_8 ks);
  void Ecriture();
  void test_avec_print(int_8 ks);
  inline int_4 StartWtIndex()  {return CurWtIndex-WSize;}
  inline int_4 CenterWtIndex() {return CurWtIndex-(WSize+1)/2;}
  inline int_4 StartWtIndex(char cw)
         {if     (cw=='l') return StartWtIndex()+W0Left;
          else if(cw=='c') return StartWtIndex()+W0Center;
          else if(cw=='r') return StartWtIndex()+W0Right;
                           return StartWtIndex();}

  int_2 DbgLevel;
  int_4 NbInput,NbOutput;
  int_4 WSizeTot,WSize,WStep;
  int_4 WSizeLeft,WSizeCenter,WSizeRight, W0Left,W0Center,W0Right;
  int_8 SNbegin,SNend;
  int_8 TotNsCount,TotDecalCount;
  r_8   R8DefVal;
  int_8 I8DefVal;

  int_4 CurWtIndex;   // Prochain index a remplir dans le buffer WSizeTot
  int_8 LastFilledSn; // Numero du dernier sample remplie
  int_8 StartSample;  // Numero de sample du 1er element du buffer WSize

  vector< TVector<r_8>   > WDataIn;
  vector< TVector<uint_8> > WFlagIn;
  vector< bool > WInFlg;
  vector< TVector<r_8>   > WDataOut;
  vector< TVector<uint_8> > WFlagOut;
  vector< bool > WOutFlg;
  vector< bool > WPutOutFlg;
  vector< bool > WPutOutOwnVector;
  vector< int_8 > OutSample;
};

#endif
